/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerEncoding;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.BuildInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.BuildResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.DeploymentResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.LogFileUrlResponseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.SpringAppImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.Utils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ActiveDeploymentCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.BuildProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.BuildResultProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.BuildResultUserSourceInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.DeploymentResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.DeploymentResourceStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.JarUploadedUserSourceInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.NetCoreZipUploadedUserSourceInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ResourceRequests;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ResourceUploadDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.RuntimeVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SourceUploadedUserSourceInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SpringApp;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.UploadedUserSourceInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.UserSourceInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.UserSourceType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareFileAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareFileClientBuilder;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class SpringAppDeploymentImpl
extends ExternalChildResourceImpl<SpringAppDeployment, DeploymentResourceInner, SpringAppImpl, SpringApp>
implements SpringAppDeployment,
SpringAppDeployment.Definition<SpringAppImpl, SpringAppDeploymentImpl>,
SpringAppDeployment.Update {
    private static final Duration MAX_BUILD_TIMEOUT = Duration.ofHours(1L);
    private BuildServiceTask buildServiceTask;
    private FunctionalTaskItem setActiveTask = null;

    SpringAppDeploymentImpl(String name, SpringAppImpl parent, DeploymentResourceInner innerObject) {
        super(name, parent, innerObject);
    }

    @Override
    public String appName() {
        if (((DeploymentResourceInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)this.innerModel()).name();
    }

    @Override
    public DeploymentSettings settings() {
        if (((DeploymentResourceInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings();
    }

    @Override
    public DeploymentResourceStatus status() {
        if (((DeploymentResourceInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)this.innerModel()).properties().status();
    }

    @Override
    public boolean isActive() {
        if (((DeploymentResourceInner)this.innerModel()).properties() == null) {
            return false;
        }
        return ((DeploymentResourceInner)this.innerModel()).properties().active();
    }

    @Override
    public List<DeploymentInstance> instances() {
        if (((DeploymentResourceInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)this.innerModel()).properties().instances();
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().startAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    @Override
    public void stop() {
        this.stopAsync().block();
    }

    @Override
    public Mono<Void> stopAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().stopAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    @Override
    public void restart() {
        this.restartAsync().block();
    }

    @Override
    public Mono<Void> restartAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().restartAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    @Override
    public String getLogFileUrl() {
        return this.getLogFileUrlAsync().block();
    }

    @Override
    public Mono<String> getLogFileUrlAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().getLogFileUrlAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name()).map(LogFileUrlResponseInner::url);
    }

    @Override
    public List<String> configFilePatterns() {
        Map<String, Map<String, Object>> addonConfigs = ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().addonConfigs();
        if (addonConfigs == null) {
            return Collections.emptyList();
        }
        Map<String, Object> configurationConfigs = addonConfigs.get("applicationConfigurationService");
        if (configurationConfigs == null) {
            return Collections.emptyList();
        }
        if (configurationConfigs.get("configFilePatterns") instanceof String) {
            String patterns = (String)configurationConfigs.get("configFilePatterns");
            return Collections.unmodifiableList(Arrays.asList(patterns.split(",")));
        }
        return Collections.emptyList();
    }

    @Override
    public Double cpu() {
        return Utils.fromCpuString(((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().resourceRequests().cpu());
    }

    @Override
    public Double memoryInGB() {
        return Utils.fromMemoryString(((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().resourceRequests().memory());
    }

    @Override
    public RuntimeVersion runtimeVersion() {
        if (this.isEnterpriseTier() || ((DeploymentResourceInner)this.innerModel()).properties() == null) {
            return null;
        }
        UserSourceInfo userSourceInfo = ((DeploymentResourceInner)this.innerModel()).properties().source();
        if (userSourceInfo instanceof JarUploadedUserSourceInfo) {
            JarUploadedUserSourceInfo uploadedUserSourceInfo = (JarUploadedUserSourceInfo)userSourceInfo;
            return RuntimeVersion.fromString(uploadedUserSourceInfo.runtimeVersion());
        }
        if (userSourceInfo instanceof NetCoreZipUploadedUserSourceInfo) {
            NetCoreZipUploadedUserSourceInfo uploadedUserSourceInfo = (NetCoreZipUploadedUserSourceInfo)userSourceInfo;
            return RuntimeVersion.fromString(uploadedUserSourceInfo.runtimeVersion());
        }
        if (userSourceInfo instanceof SourceUploadedUserSourceInfo) {
            SourceUploadedUserSourceInfo uploadedUserSourceInfo = (SourceUploadedUserSourceInfo)userSourceInfo;
            return RuntimeVersion.fromString(uploadedUserSourceInfo.runtimeVersion());
        }
        return null;
    }

    @Override
    public String jvmOptions() {
        UserSourceInfo userSourceInfo;
        if (((DeploymentResourceInner)this.innerModel()).properties() == null) {
            return null;
        }
        String jvmOptions = null;
        if (this.isEnterpriseTier() && ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings() != null) {
            Map<String, String> environment = ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().environmentVariables();
            if (environment != null) {
                jvmOptions = environment.get("JAVA_OPTS");
            }
        } else if (((DeploymentResourceInner)this.innerModel()).properties().source() != null && (userSourceInfo = ((DeploymentResourceInner)this.innerModel()).properties().source()) instanceof JarUploadedUserSourceInfo) {
            JarUploadedUserSourceInfo uploadedUserSourceInfo = (JarUploadedUserSourceInfo)userSourceInfo;
            jvmOptions = uploadedUserSourceInfo.jvmOptions();
        }
        return jvmOptions;
    }

    private void ensureDeploySettings() {
        if (((DeploymentResourceInner)this.innerModel()).properties() == null) {
            ((DeploymentResourceInner)this.innerModel()).withProperties(new DeploymentResourceProperties());
        }
        if (((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings() == null) {
            ((DeploymentResourceInner)this.innerModel()).properties().withDeploymentSettings(new DeploymentSettings());
        }
        if (((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().resourceRequests() == null) {
            ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().withResourceRequests(new ResourceRequests());
        }
    }

    private void ensureSource() {
        this.ensureSource(null);
    }

    private void ensureSource(UserSourceType type) {
        if (((DeploymentResourceInner)this.innerModel()).properties() == null) {
            ((DeploymentResourceInner)this.innerModel()).withProperties(new DeploymentResourceProperties());
        }
        if (((DeploymentResourceInner)this.innerModel()).properties().source() == null) {
            if (type == UserSourceType.JAR) {
                ((DeploymentResourceInner)this.innerModel()).properties().withSource(new JarUploadedUserSourceInfo());
            } else if (type == UserSourceType.SOURCE) {
                ((DeploymentResourceInner)this.innerModel()).properties().withSource(new SourceUploadedUserSourceInfo());
            } else if (type == UserSourceType.NET_CORE_ZIP) {
                ((DeploymentResourceInner)this.innerModel()).properties().withSource(new NetCoreZipUploadedUserSourceInfo());
            } else if (type == UserSourceType.BUILD_RESULT) {
                ((DeploymentResourceInner)this.innerModel()).properties().withSource(new BuildResultUserSourceInfo());
            } else {
                ((DeploymentResourceInner)this.innerModel()).properties().withSource(new UserSourceInfo());
            }
        }
    }

    @Override
    public SpringAppDeploymentImpl withJarFile(File jar) {
        if (this.service().isEnterpriseTier()) {
            return this.withJarFile(jar, (List)null);
        }
        this.ensureSource(UserSourceType.JAR);
        this.addDependency(context -> ((SpringAppImpl)this.parent()).getResourceUploadUrlAsync().flatMap(option -> {
            UploadedUserSourceInfo uploadedUserSourceInfo = (UploadedUserSourceInfo)((DeploymentResourceInner)this.innerModel()).properties().source();
            uploadedUserSourceInfo.withRelativePath(option.relativePath());
            return this.uploadToStorageAsync(jar, (ResourceUploadDefinition)option).then(context.voidMono());
        }));
        return this;
    }

    private ShareFileAsyncClient createShareFileAsyncClient(ResourceUploadDefinition option) {
        return new ShareFileClientBuilder().endpoint(option.uploadUrl()).httpClient(this.manager().httpPipeline().getHttpClient()).buildFileAsyncClient();
    }

    private Mono<Void> uploadToStorageAsync(File source2, ResourceUploadDefinition option) {
        try {
            ShareFileAsyncClient shareFileAsyncClient = this.createShareFileAsyncClient(option);
            return shareFileAsyncClient.create(source2.length()).flatMap(fileInfo -> shareFileAsyncClient.uploadFromFile(source2.getAbsolutePath())).then(Mono.empty());
        }
        catch (Exception e) {
            return Mono.error(e);
        }
    }

    @Override
    public SpringAppDeploymentImpl withExistingSource(UserSourceType type, String relativePath) {
        if (this.isEnterpriseTier()) {
            this.ensureSource(UserSourceType.BUILD_RESULT);
            UserSourceInfo sourceInfo = ((DeploymentResourceInner)this.innerModel()).properties().source();
            if (sourceInfo instanceof BuildResultUserSourceInfo) {
                BuildResultUserSourceInfo userSourceInfo = (BuildResultUserSourceInfo)sourceInfo;
                userSourceInfo.withBuildResultId(relativePath);
            }
        } else {
            this.ensureSource(type);
            UserSourceInfo userSourceInfo = ((DeploymentResourceInner)this.innerModel()).properties().source();
            if (userSourceInfo instanceof UploadedUserSourceInfo) {
                UploadedUserSourceInfo uploadedUserSourceInfo = (UploadedUserSourceInfo)userSourceInfo;
                uploadedUserSourceInfo.withRelativePath(relativePath);
            }
        }
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withJarFile(File jar, List<String> configFilePatterns) {
        this.ensureSource(UserSourceType.BUILD_RESULT);
        this.buildServiceTask = new BuildServiceTask(jar, configFilePatterns);
        return this;
    }

    private boolean isEnterpriseTier() {
        return this.service().isEnterpriseTier();
    }

    @Override
    public SpringAppDeploymentImpl withSourceCodeTarGzFile(File sourceCodeTarGz) {
        return this.withSourceCodeTarGzFile(sourceCodeTarGz, (List)null);
    }

    @Override
    public SpringAppDeploymentImpl withSourceCodeTarGzFile(File sourceCodeTarGz, List<String> configFilePatterns) {
        if (this.isEnterpriseTier()) {
            this.ensureSource(UserSourceType.BUILD_RESULT);
            this.buildServiceTask = new BuildServiceTask(sourceCodeTarGz, configFilePatterns, true);
        } else {
            this.ensureSource(UserSourceType.SOURCE);
            this.addDependency(context -> ((SpringAppImpl)this.parent()).getResourceUploadUrlAsync().flatMap(option -> {
                UploadedUserSourceInfo uploadedUserSourceInfo = (UploadedUserSourceInfo)((DeploymentResourceInner)this.innerModel()).properties().source();
                uploadedUserSourceInfo.withRelativePath(option.relativePath());
                return this.uploadToStorageAsync(sourceCodeTarGz, (ResourceUploadDefinition)option).then(context.voidMono());
            }));
        }
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withTargetModule(String moduleName) {
        if (this.isEnterpriseTier()) {
            this.ensureSource(UserSourceType.BUILD_RESULT);
            this.buildServiceTask.module = moduleName;
        } else {
            this.ensureSource(UserSourceType.SOURCE);
            UserSourceInfo userSourceInfo = ((DeploymentResourceInner)this.innerModel()).properties().source();
            if (userSourceInfo instanceof SourceUploadedUserSourceInfo) {
                SourceUploadedUserSourceInfo sourceUploadedUserSourceInfo = (SourceUploadedUserSourceInfo)userSourceInfo;
                sourceUploadedUserSourceInfo.withArtifactSelector(moduleName);
            }
        }
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withSingleModule() {
        return this.withTargetModule(null);
    }

    @Override
    public SpringAppDeploymentImpl withInstance(int count) {
        if (((DeploymentResourceInner)this.innerModel()).sku() == null) {
            ((DeploymentResourceInner)this.innerModel()).withSku(this.service().sku());
        }
        if (((DeploymentResourceInner)this.innerModel()).sku() == null) {
            ((DeploymentResourceInner)this.innerModel()).withSku(new Sku().withName("B0"));
        }
        ((DeploymentResourceInner)this.innerModel()).sku().withCapacity(count);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withCpu(int cpuCount) {
        return this.withCpu((double)cpuCount);
    }

    @Override
    public SpringAppDeploymentImpl withCpu(double cpuCount) {
        this.ensureDeploySettings();
        ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().resourceRequests().withCpu(Utils.toCpuString(cpuCount));
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withMemory(int sizeInGB) {
        return this.withMemory((double)sizeInGB);
    }

    @Override
    public SpringAppDeploymentImpl withMemory(double sizeInGB) {
        this.ensureDeploySettings();
        ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().resourceRequests().withMemory(Utils.toMemoryString(sizeInGB));
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withRuntime(RuntimeVersion version) {
        UserSourceInfo userSourceInfo = ((DeploymentResourceInner)this.innerModel()).properties().source();
        if (userSourceInfo instanceof JarUploadedUserSourceInfo) {
            JarUploadedUserSourceInfo uploadedUserSourceInfo = (JarUploadedUserSourceInfo)userSourceInfo;
            uploadedUserSourceInfo.withRuntimeVersion(version.toString());
        } else if (userSourceInfo instanceof NetCoreZipUploadedUserSourceInfo) {
            NetCoreZipUploadedUserSourceInfo uploadedUserSourceInfo = (NetCoreZipUploadedUserSourceInfo)userSourceInfo;
            uploadedUserSourceInfo.withRuntimeVersion(version.toString());
        } else if (userSourceInfo instanceof SourceUploadedUserSourceInfo) {
            SourceUploadedUserSourceInfo uploadedUserSourceInfo = (SourceUploadedUserSourceInfo)userSourceInfo;
            uploadedUserSourceInfo.withRuntimeVersion(version.toString());
        }
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withJvmOptions(String jvmOptions) {
        if (this.isEnterpriseTier()) {
            this.withEnvironment("JAVA_OPTS", jvmOptions);
        } else {
            this.ensureSource(UserSourceType.JAR);
            UserSourceInfo userSourceInfo = ((DeploymentResourceInner)this.innerModel()).properties().source();
            if (userSourceInfo instanceof JarUploadedUserSourceInfo) {
                JarUploadedUserSourceInfo uploadedUserSourceInfo = (JarUploadedUserSourceInfo)userSourceInfo;
                uploadedUserSourceInfo.withJvmOptions(jvmOptions);
            }
        }
        return this;
    }

    private void ensureEnvironments() {
        this.ensureDeploySettings();
        if (((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().environmentVariables() == null) {
            ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().withEnvironmentVariables(new HashMap<String, String>());
        }
    }

    private void ensureAddonConfigs() {
        this.ensureDeploySettings();
        if (((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().addonConfigs() == null) {
            ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().withAddonConfigs(new HashMap<String, Map<String, Object>>());
        }
    }

    @Override
    public SpringAppDeploymentImpl withEnvironment(String key, String value) {
        this.ensureEnvironments();
        ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().environmentVariables().put(key, value);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withoutEnvironment(String key) {
        this.ensureEnvironments();
        ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().environmentVariables().remove(key);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withVersionName(String versionName) {
        this.ensureSource();
        ((DeploymentResourceInner)this.innerModel()).properties().source().withVersion(versionName);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withActivation() {
        this.setActiveTask = context -> ((AppPlatformManagementClient)this.manager().serviceClient()).getApps().setActiveDeploymentsAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), new ActiveDeploymentCollection().withActiveDeploymentNames(Collections.singletonList(this.name()))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withConfigFilePatterns(List<String> configFilePatterns) {
        this.ensureAddonConfigs();
        Map<String, Map<String, Object>> addonConfigs = ((DeploymentResourceInner)this.innerModel()).properties().deploymentSettings().addonConfigs();
        addonConfigs.computeIfAbsent("applicationConfigurationService", s -> {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("configFilePatterns", CoreUtils.isNullOrEmpty(configFilePatterns) ? "" : String.join((CharSequence)",", configFilePatterns));
            return config;
        });
        return this;
    }

    @Override
    public void beforeGroupCreateOrUpdate() {
        super.beforeGroupCreateOrUpdate();
        if (this.buildServiceTask != null) {
            this.addDependency(this.buildServiceTask);
            this.buildServiceTask = null;
        }
        if (this.setActiveTask != null) {
            this.addPostRunDependent(this.setActiveTask);
            this.setActiveTask = null;
        }
    }

    @Override
    public Mono<SpringAppDeployment> createResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().createOrUpdateAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name(), (DeploymentResourceInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    @Override
    public Mono<SpringAppDeployment> updateResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().updateAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name(), (DeploymentResourceInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().deleteAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    @Override
    protected Mono<DeploymentResourceInner> getInnerAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().getAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    @Override
    public String id() {
        return ((DeploymentResourceInner)this.innerModel()).id();
    }

    @Override
    public SpringAppDeploymentImpl update() {
        this.prepareUpdate();
        return this;
    }

    private AppPlatformManager manager() {
        return ((SpringAppImpl)this.parent()).manager();
    }

    @Override
    public SpringAppImpl attach() {
        return ((SpringAppImpl)this.parent()).addDeployment(this);
    }

    private SpringAppImpl app() {
        return (SpringAppImpl)this.parent();
    }

    private SpringServiceImpl service() {
        return (SpringServiceImpl)((SpringAppImpl)this.parent()).parent();
    }

    private class BuildServiceTask
    implements FunctionalTaskItem {
        private final File file;
        private final boolean sourceCodeTarGz;
        private final List<String> configFilePatterns;
        private String module;

        BuildServiceTask(File file, List<String> configFilePatterns) {
            this(file, configFilePatterns, false);
        }

        BuildServiceTask(File file, List<String> configFilePatterns, boolean sourceCodeTarGz) {
            this.file = file;
            this.configFilePatterns = configFilePatterns;
            this.sourceCodeTarGz = sourceCodeTarGz;
        }

        @Override
        public Mono<Indexable> apply(FunctionalTaskItem.Context context) {
            return SpringAppDeploymentImpl.this.app().getResourceUploadUrlAsync().flatMap(option -> this.uploadAndBuildAsync(this.file, (ResourceUploadDefinition)option).flatMap(buildId -> {
                BuildResultUserSourceInfo userSourceInfo = (BuildResultUserSourceInfo)((DeploymentResourceInner)SpringAppDeploymentImpl.this.innerModel()).properties().source();
                userSourceInfo.withBuildResultId((String)buildId);
                SpringAppDeploymentImpl.this.withConfigFilePatterns((List)this.configFilePatterns);
                return Mono.empty();
            }).then(context.voidMono()));
        }

        private Mono<String> uploadAndBuildAsync(File source2, ResourceUploadDefinition option) {
            return SpringAppDeploymentImpl.this.uploadToStorageAsync(source2, option).then(this.enqueueBuildAsync(option)).flatMap(this.waitForBuildAsync());
        }

        private Mono<String> enqueueBuildAsync(ResourceUploadDefinition option) {
            BuildProperties buildProperties = new BuildProperties().withBuilder(String.format("%s/buildservices/%s/builders/%s", SpringAppDeploymentImpl.this.service().id(), "default", "default")).withAgentPool(String.format("%s/buildservices/%s/agentPools/%s", SpringAppDeploymentImpl.this.service().id(), "default", "default")).withRelativePath(option.relativePath());
            if (this.sourceCodeTarGz) {
                HashMap<String, String> buildEnv = buildProperties.env() == null ? new HashMap() : buildProperties.env();
                buildProperties.withEnv(buildEnv);
                if (this.module != null) {
                    buildEnv.put("BP_MAVEN_BUILT_MODULE", this.module);
                }
            }
            return ((AppPlatformManagementClient)SpringAppDeploymentImpl.this.manager().serviceClient()).getBuildServices().createOrUpdateBuildAsync(SpringAppDeploymentImpl.this.service().resourceGroupName(), SpringAppDeploymentImpl.this.service().name(), "default", SpringAppDeploymentImpl.this.app().name(), new BuildInner().withProperties(buildProperties)).map(inner -> inner.properties().triggeredBuildResult().id());
        }

        private Function<String, Mono<? extends String>> waitForBuildAsync() {
            AtomicLong pollCount = new AtomicLong();
            Duration pollDuration = ((AppPlatformManagementClient)SpringAppDeploymentImpl.this.manager().serviceClient()).getDefaultPollInterval();
            return buildId -> ((AppPlatformManagementClient)SpringAppDeploymentImpl.this.manager().serviceClient()).getBuildServices().getBuildResultWithResponseAsync(SpringAppDeploymentImpl.this.service().resourceGroupName(), SpringAppDeploymentImpl.this.service().name(), "default", ((SpringAppImpl)SpringAppDeploymentImpl.this.parent()).name(), ResourceUtils.nameFromResourceId(buildId)).flatMap(response -> {
                if (pollDuration.multipliedBy(pollCount.get()).compareTo(MAX_BUILD_TIMEOUT) < 0) {
                    BuildResultProvisioningState state = ((BuildResultInner)response.getValue()).properties().provisioningState();
                    if (state == BuildResultProvisioningState.SUCCEEDED) {
                        return Mono.just(buildId);
                    }
                    if (state == BuildResultProvisioningState.QUEUING || state == BuildResultProvisioningState.BUILDING) {
                        return Mono.empty();
                    }
                    AppPlatformManagementClientImpl client = (AppPlatformManagementClientImpl)SpringAppDeploymentImpl.this.manager().serviceClient();
                    return Mono.error(new ManagementException(String.format("Build failed for file: %s, buildId: %s", this.file.getName(), buildId), new HttpResponseImpl(response, client.getSerializerAdapter())));
                }
                return Mono.error(new ManagementException(String.format("Build timeout for file: %s, buildId: %s", this.file.getName(), buildId), null));
            }).repeatWhenEmpty(longFlux -> longFlux.flatMap(index -> {
                pollCount.set((long)index);
                return Mono.delay(ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(pollDuration));
            }));
        }

        private class HttpResponseImpl<T>
        extends HttpResponse {
            private final Response<T> response;
            private final SerializerAdapter serializerAdapter;

            protected HttpResponseImpl(Response<T> response, SerializerAdapter serializerAdapter) {
                super(response.getRequest());
                this.response = response;
                this.serializerAdapter = serializerAdapter;
            }

            @Override
            public int getStatusCode() {
                return this.response.getStatusCode();
            }

            @Override
            public String getHeaderValue(String header) {
                return this.response.getHeaders().getValue(header);
            }

            @Override
            public HttpHeaders getHeaders() {
                return this.response.getHeaders();
            }

            @Override
            public Flux<ByteBuffer> getBody() {
                try {
                    return Flux.just(ByteBuffer.wrap(this.serializerAdapter.serializeToBytes(this.response.getValue(), SerializerEncoding.JSON)));
                }
                catch (IOException e) {
                    return Flux.empty();
                }
            }

            @Override
            public Mono<byte[]> getBodyAsByteArray() {
                try {
                    return Mono.just(this.serializerAdapter.serializeToBytes(this.response.getValue(), SerializerEncoding.JSON));
                }
                catch (IOException e) {
                    return Mono.empty();
                }
            }

            @Override
            public Mono<String> getBodyAsString() {
                return Mono.just(this.serializerAdapter.serializeRaw(this.response.getValue()));
            }

            @Override
            public Mono<String> getBodyAsString(Charset charset) {
                return this.getBodyAsString();
            }
        }
    }
}

