/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.exception.HttpResponseException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

class Utils {
    Utils() {
    }

    static String base16Encode(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            stringBuilder.append(String.format("%02X", b));
        }
        return stringBuilder.toString();
    }

    static String smartCompletionPrivateRegistryImage(String imageAndTag, String serverUrl) {
        try {
            URL url = new URL(serverUrl);
            String registryServer = url.getAuthority();
            String path = url.getPath();
            if (!registryServer.isEmpty() && !imageAndTag.trim().startsWith(registryServer)) {
                String segment;
                String[] segments = imageAndTag.split(Pattern.quote("/"));
                if (segments.length == 1) {
                    imageAndTag = Utils.completePrivateRegistryImage(imageAndTag, registryServer, path);
                }
                if (!(segments.length <= 1 || (segment = segments[0]).isEmpty() || segment.contains(".") || segment.contains(":") || segment.equals(registryServer))) {
                    imageAndTag = Utils.completePrivateRegistryImage(imageAndTag, registryServer, path);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return imageAndTag;
    }

    private static String completePrivateRegistryImage(String imageAndTag, String registryServer, String path) {
        imageAndTag = (path = Utils.removeLeadingChar(Utils.removeTrailingChar(path, '/'), '/')).isEmpty() ? String.format("%s/%s", registryServer, imageAndTag.trim()) : String.format("%s/%s/%s", registryServer, path, imageAndTag.trim());
        return imageAndTag;
    }

    private static String removeLeadingChar(String s, char c) {
        int index;
        for (index = 0; index < s.length() && s.charAt(index) == c; ++index) {
        }
        return s.substring(index);
    }

    private static String removeTrailingChar(String s, char c) {
        int index;
        for (index = s.length() - 1; index >= 0 && s.charAt(index) == c; --index) {
        }
        return s.substring(0, index + 1);
    }

    static Mono<byte[]> downloadFileAsync(String url, HttpPipeline httpPipeline) {
        HttpRequest request = new HttpRequest(HttpMethod.GET, url);
        return httpPipeline.send(request).flatMap(response1 -> {
            int code = response1.getStatusCode();
            if (code == 200) {
                return Mono.just(response1);
            }
            return Mono.error(new HttpResponseException((HttpResponse)response1));
        }).flatMap(HttpResponse::getBodyAsByteArray);
    }
}

