/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WorkflowRunActionScopeRepetitionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.WorkflowRunActionRepetitionDefinitionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WorkflowRunActionRepetitionDefinitionCollection;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class WorkflowRunActionScopeRepetitionsClientImpl
implements WorkflowRunActionScopeRepetitionsClient {
    private final WorkflowRunActionScopeRepetitionsService service;
    private final WebSiteManagementClientImpl client;

    WorkflowRunActionScopeRepetitionsClientImpl(WebSiteManagementClientImpl client) {
        this.service = RestProxy.create(WorkflowRunActionScopeRepetitionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowRunActionRepetitionDefinitionInner>> listSinglePageAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (runName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runName is required and cannot be null."));
        }
        if (actionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter actionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, runName, actionName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, WorkflowRunActionRepetitionDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowRunActionRepetitionDefinitionCollection)res.getValue()).value(), ((WorkflowRunActionRepetitionDefinitionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowRunActionRepetitionDefinitionInner>> listSinglePageAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (runName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runName is required and cannot be null."));
        }
        if (actionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter actionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, runName, actionName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, WorkflowRunActionRepetitionDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowRunActionRepetitionDefinitionCollection)res.getValue()).value(), ((WorkflowRunActionRepetitionDefinitionCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WorkflowRunActionRepetitionDefinitionInner> listAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName) {
        return new PagedFlux<WorkflowRunActionRepetitionDefinitionInner>(() -> this.listSinglePageAsync(resourceGroupName, name, workflowName, runName, actionName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WorkflowRunActionRepetitionDefinitionInner> listAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, Context context) {
        return new PagedFlux<WorkflowRunActionRepetitionDefinitionInner>(() -> this.listSinglePageAsync(resourceGroupName, name, workflowName, runName, actionName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkflowRunActionRepetitionDefinitionInner> list(String resourceGroupName, String name, String workflowName, String runName, String actionName) {
        return new PagedIterable<WorkflowRunActionRepetitionDefinitionInner>(this.listAsync(resourceGroupName, name, workflowName, runName, actionName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkflowRunActionRepetitionDefinitionInner> list(String resourceGroupName, String name, String workflowName, String runName, String actionName, Context context) {
        return new PagedIterable<WorkflowRunActionRepetitionDefinitionInner>(this.listAsync(resourceGroupName, name, workflowName, runName, actionName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<WorkflowRunActionRepetitionDefinitionInner>> getWithResponseAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (runName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runName is required and cannot be null."));
        }
        if (actionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter actionName is required and cannot be null."));
        }
        if (repetitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter repetitionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, runName, actionName, repetitionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkflowRunActionRepetitionDefinitionInner>> getWithResponseAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (runName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runName is required and cannot be null."));
        }
        if (actionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter actionName is required and cannot be null."));
        }
        if (repetitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter repetitionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, runName, actionName, repetitionName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WorkflowRunActionRepetitionDefinitionInner> getAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName) {
        return this.getWithResponseAsync(resourceGroupName, name, workflowName, runName, actionName, repetitionName).flatMap(res -> Mono.justOrEmpty((WorkflowRunActionRepetitionDefinitionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkflowRunActionRepetitionDefinitionInner> getWithResponse(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, name, workflowName, runName, actionName, repetitionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowRunActionRepetitionDefinitionInner get(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName) {
        return this.getWithResponse(resourceGroupName, name, workflowName, runName, actionName, repetitionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowRunActionRepetitionDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, WorkflowRunActionRepetitionDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowRunActionRepetitionDefinitionCollection)res.getValue()).value(), ((WorkflowRunActionRepetitionDefinitionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowRunActionRepetitionDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, WorkflowRunActionRepetitionDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowRunActionRepetitionDefinitionCollection)res.getValue()).value(), ((WorkflowRunActionRepetitionDefinitionCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    public static interface WorkflowRunActionScopeRepetitionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/runs/{runName}/actions/{actionName}/scopeRepetitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowRunActionRepetitionDefinitionCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @PathParam(value="runName") String var6, @PathParam(value="actionName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/runs/{runName}/actions/{actionName}/scopeRepetitions/{repetitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowRunActionRepetitionDefinitionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @PathParam(value="runName") String var6, @PathParam(value="actionName") String var7, @PathParam(value="repetitionName") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowRunActionRepetitionDefinitionCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

