/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DaysOfWeek;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RecurrenceScheduleOccurrence;
import java.io.IOException;
import java.util.List;

public final class RecurrenceSchedule
implements JsonSerializable<RecurrenceSchedule> {
    private List<Integer> minutes;
    private List<Integer> hours;
    private List<DaysOfWeek> weekDays;
    private List<Integer> monthDays;
    private List<RecurrenceScheduleOccurrence> monthlyOccurrences;

    public List<Integer> minutes() {
        return this.minutes;
    }

    public RecurrenceSchedule withMinutes(List<Integer> minutes) {
        this.minutes = minutes;
        return this;
    }

    public List<Integer> hours() {
        return this.hours;
    }

    public RecurrenceSchedule withHours(List<Integer> hours) {
        this.hours = hours;
        return this;
    }

    public List<DaysOfWeek> weekDays() {
        return this.weekDays;
    }

    public RecurrenceSchedule withWeekDays(List<DaysOfWeek> weekDays) {
        this.weekDays = weekDays;
        return this;
    }

    public List<Integer> monthDays() {
        return this.monthDays;
    }

    public RecurrenceSchedule withMonthDays(List<Integer> monthDays) {
        this.monthDays = monthDays;
        return this;
    }

    public List<RecurrenceScheduleOccurrence> monthlyOccurrences() {
        return this.monthlyOccurrences;
    }

    public RecurrenceSchedule withMonthlyOccurrences(List<RecurrenceScheduleOccurrence> monthlyOccurrences) {
        this.monthlyOccurrences = monthlyOccurrences;
        return this;
    }

    public void validate() {
        if (this.monthlyOccurrences() != null) {
            this.monthlyOccurrences().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("minutes", this.minutes, (writer, element) -> writer.writeInt((int)element));
        jsonWriter.writeArrayField("hours", this.hours, (writer, element) -> writer.writeInt((int)element));
        jsonWriter.writeArrayField("weekDays", this.weekDays, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("monthDays", this.monthDays, (writer, element) -> writer.writeInt((int)element));
        jsonWriter.writeArrayField("monthlyOccurrences", this.monthlyOccurrences, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static RecurrenceSchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecurrenceSchedule deserializedRecurrenceSchedule = new RecurrenceSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minutes".equals(fieldName)) {
                    List<Integer> minutes = reader.readArray(reader1 -> reader1.getInt());
                    deserializedRecurrenceSchedule.minutes = minutes;
                    continue;
                }
                if ("hours".equals(fieldName)) {
                    List<Integer> hours = reader.readArray(reader1 -> reader1.getInt());
                    deserializedRecurrenceSchedule.hours = hours;
                    continue;
                }
                if ("weekDays".equals(fieldName)) {
                    List<DaysOfWeek> weekDays = reader.readArray(reader1 -> DaysOfWeek.fromString(reader1.getString()));
                    deserializedRecurrenceSchedule.weekDays = weekDays;
                    continue;
                }
                if ("monthDays".equals(fieldName)) {
                    List<Integer> monthDays = reader.readArray(reader1 -> reader1.getInt());
                    deserializedRecurrenceSchedule.monthDays = monthDays;
                    continue;
                }
                if ("monthlyOccurrences".equals(fieldName)) {
                    List<RecurrenceScheduleOccurrence> monthlyOccurrences = reader.readArray(reader1 -> RecurrenceScheduleOccurrence.fromJson(reader1));
                    deserializedRecurrenceSchedule.monthlyOccurrences = monthlyOccurrences;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecurrenceSchedule;
        });
    }
}

