/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphCalendarRoleType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEmailAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphCalendarPermission
extends MicrosoftGraphEntity {
    private List<MicrosoftGraphCalendarRoleType> allowedRoles;
    private MicrosoftGraphEmailAddress emailAddress;
    private Boolean isInsideOrganization;
    private Boolean isRemovable;
    private MicrosoftGraphCalendarRoleType role;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphCalendarRoleType> allowedRoles() {
        return this.allowedRoles;
    }

    public MicrosoftGraphCalendarPermission withAllowedRoles(List<MicrosoftGraphCalendarRoleType> allowedRoles) {
        this.allowedRoles = allowedRoles;
        return this;
    }

    public MicrosoftGraphEmailAddress emailAddress() {
        return this.emailAddress;
    }

    public MicrosoftGraphCalendarPermission withEmailAddress(MicrosoftGraphEmailAddress emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    public Boolean isInsideOrganization() {
        return this.isInsideOrganization;
    }

    public MicrosoftGraphCalendarPermission withIsInsideOrganization(Boolean isInsideOrganization) {
        this.isInsideOrganization = isInsideOrganization;
        return this;
    }

    public Boolean isRemovable() {
        return this.isRemovable;
    }

    public MicrosoftGraphCalendarPermission withIsRemovable(Boolean isRemovable) {
        this.isRemovable = isRemovable;
        return this;
    }

    public MicrosoftGraphCalendarRoleType role() {
        return this.role;
    }

    public MicrosoftGraphCalendarPermission withRole(MicrosoftGraphCalendarRoleType role) {
        this.role = role;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphCalendarPermission withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphCalendarPermission withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.emailAddress() != null) {
            this.emailAddress().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("allowedRoles", this.allowedRoles, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("emailAddress", this.emailAddress);
        jsonWriter.writeBooleanField("isInsideOrganization", this.isInsideOrganization);
        jsonWriter.writeBooleanField("isRemovable", this.isRemovable);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphCalendarPermission fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphCalendarPermission deserializedMicrosoftGraphCalendarPermission = new MicrosoftGraphCalendarPermission();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphCalendarPermission.withId(reader.getString());
                    continue;
                }
                if ("allowedRoles".equals(fieldName)) {
                    List<MicrosoftGraphCalendarRoleType> allowedRoles = reader.readArray(reader1 -> MicrosoftGraphCalendarRoleType.fromString(reader1.getString()));
                    deserializedMicrosoftGraphCalendarPermission.allowedRoles = allowedRoles;
                    continue;
                }
                if ("emailAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphCalendarPermission.emailAddress = MicrosoftGraphEmailAddress.fromJson(reader);
                    continue;
                }
                if ("isInsideOrganization".equals(fieldName)) {
                    deserializedMicrosoftGraphCalendarPermission.isInsideOrganization = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isRemovable".equals(fieldName)) {
                    deserializedMicrosoftGraphCalendarPermission.isRemovable = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedMicrosoftGraphCalendarPermission.role = MicrosoftGraphCalendarRoleType.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphCalendarPermission.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphCalendarPermission;
        });
    }
}

