/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.GlobalAdministratorsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class GlobalAdministratorsClientImpl
implements GlobalAdministratorsClient {
    private final GlobalAdministratorsService service;
    private final AuthorizationManagementClientImpl client;

    GlobalAdministratorsClientImpl(AuthorizationManagementClientImpl client) {
        this.service = RestProxy.create(GlobalAdministratorsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> elevateAccessWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2015-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.elevateAccess(this.client.getEndpoint(), "2015-07-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> elevateAccessWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2015-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.elevateAccess(this.client.getEndpoint(), "2015-07-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> elevateAccessAsync() {
        return this.elevateAccessWithResponseAsync().flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> elevateAccessWithResponse(Context context) {
        return this.elevateAccessWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void elevateAccess() {
        this.elevateAccessWithResponse(Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    public static interface GlobalAdministratorsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Authorization/elevateAccess")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> elevateAccess(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

