/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.utils;

import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public class RoleAssignmentHelper {
    private static final String CURRENT_RESOURCE_GROUP_SCOPE = "CURRENT_RESOURCE_GROUP";
    private final AuthorizationManager authorizationManager;
    private final IdProvider idProvider;
    private final TaskGroup preRunTaskGroup;

    public RoleAssignmentHelper(AuthorizationManager authorizationManager, TaskGroup taskGroup, IdProvider idProvider) {
        this.authorizationManager = Objects.requireNonNull(authorizationManager);
        this.idProvider = Objects.requireNonNull(idProvider);
        this.preRunTaskGroup = Objects.requireNonNull(taskGroup);
    }

    public RoleAssignmentHelper withAccessToCurrentResourceGroup(BuiltInRole asRole) {
        return this.withAccessTo(CURRENT_RESOURCE_GROUP_SCOPE, asRole);
    }

    public RoleAssignmentHelper withAccessTo(String scope, BuiltInRole asRole) {
        FunctionalTaskItem creator = cxt -> {
            String principalId = this.idProvider.principalId();
            if (principalId == null) {
                return cxt.voidMono();
            }
            String roleAssignmentName = this.authorizationManager.internalContext().randomUuid();
            String resourceScope = scope.equals(CURRENT_RESOURCE_GROUP_SCOPE) ? RoleAssignmentHelper.resourceGroupId(this.idProvider.resourceId()) : scope;
            return ((RoleAssignment.DefinitionStages.Blank)this.authorizationManager.roleAssignments().define(roleAssignmentName)).forObjectId(principalId).withBuiltInRole(asRole).withScope(resourceScope).createAsync().cast(Indexable.class).onErrorResume(throwable -> {
                if (RoleAssignmentHelper.isRoleAssignmentExists(throwable)) {
                    return cxt.voidMono();
                }
                return Mono.error(throwable);
            });
        };
        this.preRunTaskGroup.addPostRunDependent(creator, this.authorizationManager.internalContext());
        return this;
    }

    public RoleAssignmentHelper withAccessToCurrentResourceGroup(String roleDefinitionId) {
        return this.withAccessTo(CURRENT_RESOURCE_GROUP_SCOPE, roleDefinitionId);
    }

    public RoleAssignmentHelper withAccessTo(String scope, String roleDefinitionId) {
        FunctionalTaskItem creator = cxt -> {
            String principalId = this.idProvider.principalId();
            if (principalId == null) {
                return cxt.voidMono();
            }
            String roleAssignmentName = this.authorizationManager.internalContext().randomUuid();
            String resourceScope = scope.equals(CURRENT_RESOURCE_GROUP_SCOPE) ? RoleAssignmentHelper.resourceGroupId(this.idProvider.resourceId()) : scope;
            return ((RoleAssignment.DefinitionStages.Blank)this.authorizationManager.roleAssignments().define(roleAssignmentName)).forObjectId(principalId).withRoleDefinition(roleDefinitionId).withScope(resourceScope).createAsync().cast(Indexable.class).onErrorResume(throwable -> {
                if (RoleAssignmentHelper.isRoleAssignmentExists(throwable)) {
                    return cxt.voidMono();
                }
                return Mono.error(throwable);
            });
        };
        this.preRunTaskGroup.addPostRunDependent(creator, this.authorizationManager.internalContext());
        return this;
    }

    public RoleAssignmentHelper withoutAccessTo(RoleAssignment roleAssignment) {
        String principalId = roleAssignment.principalId();
        if (principalId == null || !principalId.equalsIgnoreCase(this.idProvider.principalId())) {
            return this;
        }
        FunctionalTaskItem remover = cxt -> this.authorizationManager.roleAssignments().deleteByIdAsync(roleAssignment.id()).then(cxt.voidMono());
        this.preRunTaskGroup.addPostRunDependent(remover);
        return this;
    }

    public RoleAssignmentHelper withoutAccessTo(String scope, BuiltInRole asRole) {
        FunctionalTaskItem remover = cxt -> this.authorizationManager.roleDefinitions().getByScopeAndRoleNameAsync(scope, asRole.toString()).flatMap(roleDefinition -> this.authorizationManager.roleAssignments().listByScopeAsync(scope).filter(roleAssignment -> {
            if (roleDefinition != null && roleAssignment != null) {
                return roleAssignment.roleDefinitionId().equalsIgnoreCase(roleDefinition.id()) && roleAssignment.principalId().equalsIgnoreCase(this.idProvider.principalId());
            }
            return false;
        }).last()).flatMap(roleAssignment -> this.authorizationManager.roleAssignments().deleteByIdAsync(roleAssignment.id()).then(cxt.voidMono()));
        this.preRunTaskGroup.addPostRunDependent(remover);
        return this;
    }

    private static String resourceGroupId(String id) {
        ResourceId resourceId = ResourceId.fromString(id);
        StringBuilder builder = new StringBuilder();
        builder.append("/subscriptions/").append(resourceId.subscriptionId()).append("/resourceGroups/").append(resourceId.resourceGroupName());
        return builder.toString();
    }

    private static boolean isRoleAssignmentExists(Throwable throwable) {
        ManagementException exception;
        return throwable instanceof ManagementException && (exception = (ManagementException)throwable).getValue() != null && exception.getValue().getCode() != null && exception.getValue().getCode().equalsIgnoreCase("RoleAssignmentExists");
    }

    public static interface IdProvider {
        public String principalId();

        public String resourceId();
    }
}

