/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.RankingsResponseTablesItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class RankingsResponseInner
implements JsonSerializable<RankingsResponseInner> {
    private OffsetDateTime dateTimeBegin;
    private OffsetDateTime dateTimeEnd;
    private List<RankingsResponseTablesItem> tables;

    public OffsetDateTime dateTimeBegin() {
        return this.dateTimeBegin;
    }

    public RankingsResponseInner withDateTimeBegin(OffsetDateTime dateTimeBegin) {
        this.dateTimeBegin = dateTimeBegin;
        return this;
    }

    public OffsetDateTime dateTimeEnd() {
        return this.dateTimeEnd;
    }

    public RankingsResponseInner withDateTimeEnd(OffsetDateTime dateTimeEnd) {
        this.dateTimeEnd = dateTimeEnd;
        return this;
    }

    public List<RankingsResponseTablesItem> tables() {
        return this.tables;
    }

    public RankingsResponseInner withTables(List<RankingsResponseTablesItem> tables) {
        this.tables = tables;
        return this;
    }

    public void validate() {
        if (this.tables() != null) {
            this.tables().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dateTimeBegin", this.dateTimeBegin == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTimeBegin));
        jsonWriter.writeStringField("dateTimeEnd", this.dateTimeEnd == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTimeEnd));
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static RankingsResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RankingsResponseInner deserializedRankingsResponseInner = new RankingsResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateTimeBegin".equals(fieldName)) {
                    deserializedRankingsResponseInner.dateTimeBegin = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("dateTimeEnd".equals(fieldName)) {
                    deserializedRankingsResponseInner.dateTimeEnd = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("tables".equals(fieldName)) {
                    List<RankingsResponseTablesItem> tables = reader.readArray(reader1 -> RankingsResponseTablesItem.fromJson(reader1));
                    deserializedRankingsResponseInner.tables = tables;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRankingsResponseInner;
        });
    }
}

