/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SystemData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CloudServiceProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CloudServiceInner
extends Resource {
    private CloudServiceProperties properties;
    private SystemData systemData;
    private List<String> zones;
    private String type;
    private String name;
    private String id;

    public CloudServiceProperties properties() {
        return this.properties;
    }

    public CloudServiceInner withProperties(CloudServiceProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public CloudServiceInner withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public CloudServiceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CloudServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public CloudServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeJsonField("systemData", this.systemData);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudServiceInner deserializedCloudServiceInner = new CloudServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCloudServiceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCloudServiceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCloudServiceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCloudServiceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCloudServiceInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCloudServiceInner.properties = CloudServiceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCloudServiceInner.systemData = SystemData.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedCloudServiceInner.zones = zones;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceInner;
        });
    }
}

