/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DedicatedHostInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DedicatedHostLicenseTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DedicatedHostProperties
implements JsonSerializable<DedicatedHostProperties> {
    private Integer platformFaultDomain;
    private Boolean autoReplaceOnFailure;
    private String hostId;
    private List<SubResourceReadOnly> virtualMachines;
    private DedicatedHostLicenseTypes licenseType;
    private OffsetDateTime provisioningTime;
    private String provisioningState;
    private DedicatedHostInstanceView instanceView;
    private OffsetDateTime timeCreated;

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public DedicatedHostProperties withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public Boolean autoReplaceOnFailure() {
        return this.autoReplaceOnFailure;
    }

    public DedicatedHostProperties withAutoReplaceOnFailure(Boolean autoReplaceOnFailure) {
        this.autoReplaceOnFailure = autoReplaceOnFailure;
        return this;
    }

    public String hostId() {
        return this.hostId;
    }

    public List<SubResourceReadOnly> virtualMachines() {
        return this.virtualMachines;
    }

    public DedicatedHostLicenseTypes licenseType() {
        return this.licenseType;
    }

    public DedicatedHostProperties withLicenseType(DedicatedHostLicenseTypes licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public OffsetDateTime provisioningTime() {
        return this.provisioningTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public DedicatedHostInstanceView instanceView() {
        return this.instanceView;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.virtualMachines() != null) {
            this.virtualMachines().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("platformFaultDomain", this.platformFaultDomain);
        jsonWriter.writeBooleanField("autoReplaceOnFailure", this.autoReplaceOnFailure);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHostProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostProperties deserializedDedicatedHostProperties = new DedicatedHostProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("platformFaultDomain".equals(fieldName)) {
                    deserializedDedicatedHostProperties.platformFaultDomain = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("autoReplaceOnFailure".equals(fieldName)) {
                    deserializedDedicatedHostProperties.autoReplaceOnFailure = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hostId".equals(fieldName)) {
                    deserializedDedicatedHostProperties.hostId = reader.getString();
                    continue;
                }
                if ("virtualMachines".equals(fieldName)) {
                    List<SubResourceReadOnly> virtualMachines = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    deserializedDedicatedHostProperties.virtualMachines = virtualMachines;
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedDedicatedHostProperties.licenseType = DedicatedHostLicenseTypes.fromString(reader.getString());
                    continue;
                }
                if ("provisioningTime".equals(fieldName)) {
                    deserializedDedicatedHostProperties.provisioningTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDedicatedHostProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedDedicatedHostProperties.instanceView = DedicatedHostInstanceView.fromJson(reader);
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedDedicatedHostProperties.timeCreated = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHostProperties;
        });
    }
}

