/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.VirtualMachineImagesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineImageImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachinePublishers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.util.List;

public class VirtualMachineImagesImpl
implements VirtualMachineImages {
    private final VirtualMachinePublishers publishers;
    private final VirtualMachineImagesClient client;

    public VirtualMachineImagesImpl(VirtualMachinePublishers publishers, VirtualMachineImagesClient client) {
        this.publishers = publishers;
        this.client = client;
    }

    @Override
    public VirtualMachineImage getImage(Region region, String publisherName, String offerName, String skuName, String version) {
        VirtualMachineImageInner innerImage;
        List<VirtualMachineImageResourceInner> innerImages;
        if ("latest".equalsIgnoreCase(version) && (innerImages = this.client.listWithResponse(region.name(), publisherName, offerName, skuName, null, 1, "name desc", Context.NONE).getValue()) != null && !innerImages.isEmpty()) {
            VirtualMachineImageResourceInner innerImageResource = innerImages.get(0);
            version = innerImageResource.name();
        }
        return (innerImage = this.client.get(region.name(), publisherName, offerName, skuName, version)) != null ? new VirtualMachineImageImpl(region, publisherName, offerName, skuName, version, innerImage) : null;
    }

    @Override
    public VirtualMachineImage getImage(String region, String publisherName, String offerName, String skuName, String version) {
        VirtualMachineImageInner innerImage;
        List<VirtualMachineImageResourceInner> innerImages;
        if ("latest".equalsIgnoreCase(version) && (innerImages = this.client.listWithResponse(region, publisherName, offerName, skuName, null, 1, "name desc", Context.NONE).getValue()) != null && !innerImages.isEmpty()) {
            VirtualMachineImageResourceInner innerImageResource = innerImages.get(0);
            version = innerImageResource.name();
        }
        return (innerImage = this.client.get(region, publisherName, offerName, skuName, version)) != null ? new VirtualMachineImageImpl(Region.fromName(region), publisherName, offerName, skuName, version, innerImage) : null;
    }

    @Override
    public PagedIterable<VirtualMachineImage> listByRegion(Region location) {
        return this.listByRegion(location.toString());
    }

    @Override
    public PagedIterable<VirtualMachineImage> listByRegion(String regionName) {
        return new PagedIterable<VirtualMachineImage>(this.listByRegionAsync(regionName));
    }

    @Override
    public PagedFlux<VirtualMachineImage> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    @Override
    public PagedFlux<VirtualMachineImage> listByRegionAsync(String regionName) {
        return PagedConverter.flatMapPage(this.publishers().listByRegionAsync(regionName), virtualMachinePublisher -> virtualMachinePublisher.offers().listAsync().onErrorResume(ManagementException.class, e -> e.getResponse().getStatusCode() == 404 ? Flux.empty() : Flux.error(e)).flatMap(virtualMachineOffer -> virtualMachineOffer.skus().listAsync()).flatMap(virtualMachineSku -> virtualMachineSku.images().listAsync()));
    }

    @Override
    public VirtualMachinePublishers publishers() {
        return this.publishers;
    }
}

