/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;

public final class KeyVaultSecretReference
implements JsonSerializable<KeyVaultSecretReference> {
    private String secretUrl;
    private SubResource sourceVault;
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSecretReference.class);

    public String secretUrl() {
        return this.secretUrl;
    }

    public KeyVaultSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

    public SubResource sourceVault() {
        return this.sourceVault;
    }

    public KeyVaultSecretReference withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    public void validate() {
        if (this.secretUrl() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property secretUrl in model KeyVaultSecretReference"));
        }
        if (this.sourceVault() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sourceVault in model KeyVaultSecretReference"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretUrl", this.secretUrl);
        jsonWriter.writeJsonField("sourceVault", this.sourceVault);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultSecretReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultSecretReference deserializedKeyVaultSecretReference = new KeyVaultSecretReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("secretUrl".equals(fieldName)) {
                    deserializedKeyVaultSecretReference.secretUrl = reader.getString();
                    continue;
                }
                if ("sourceVault".equals(fieldName)) {
                    deserializedKeyVaultSecretReference.sourceVault = SubResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultSecretReference;
        });
    }
}

