/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.ContainersClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models.ContainerAttachResponseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models.ContainerExecResponseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models.LogsInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerExecRequest;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class ContainersClientImpl
implements ContainersClient {
    private final ContainersService service;
    private final ContainerInstanceManagementClientImpl client;

    ContainersClientImpl(ContainerInstanceManagementClientImpl client) {
        this.service = RestProxy.create(ContainersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogsInner>> listLogsWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listLogs(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, tail, timestamps, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogsInner>> listLogsWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listLogs(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, tail, timestamps, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName) {
        Integer tail = null;
        Boolean timestamps = null;
        return this.listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps).flatMap(res -> Mono.justOrEmpty((LogsInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogsInner> listLogsWithResponse(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps, Context context) {
        return this.listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogsInner listLogs(String resourceGroupName, String containerGroupName, String containerName) {
        Integer tail = null;
        Boolean timestamps = null;
        return this.listLogsWithResponse(resourceGroupName, containerGroupName, containerName, tail, timestamps, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerExecResponseInner>> executeCommandWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (containerExecRequest == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null."));
        }
        containerExecRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.executeCommand(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, containerExecRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ContainerExecResponseInner>> executeCommandWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (containerExecRequest == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null."));
        }
        containerExecRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.executeCommand(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, containerExecRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerExecResponseInner> executeCommandAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        return this.executeCommandWithResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).flatMap(res -> Mono.justOrEmpty((ContainerExecResponseInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContainerExecResponseInner> executeCommandWithResponse(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest, Context context) {
        return this.executeCommandWithResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContainerExecResponseInner executeCommand(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        return this.executeCommandWithResponse(resourceGroupName, containerGroupName, containerName, containerExecRequest, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerAttachResponseInner>> attachWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.attach(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ContainerAttachResponseInner>> attachWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.attach(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerAttachResponseInner> attachAsync(String resourceGroupName, String containerGroupName, String containerName) {
        return this.attachWithResponseAsync(resourceGroupName, containerGroupName, containerName).flatMap(res -> Mono.justOrEmpty((ContainerAttachResponseInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContainerAttachResponseInner> attachWithResponse(String resourceGroupName, String containerGroupName, String containerName, Context context) {
        return this.attachWithResponseAsync(resourceGroupName, containerGroupName, containerName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContainerAttachResponseInner attach(String resourceGroupName, String containerGroupName, String containerName) {
        return this.attachWithResponse(resourceGroupName, containerGroupName, containerName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerInstanceMan")
    public static interface ContainersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/logs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogsInner>> listLogs(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="containerGroupName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="tail") Integer var7, @QueryParam(value="timestamps") Boolean var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/exec")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ContainerExecResponseInner>> executeCommand(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="containerGroupName") String var5, @PathParam(value="containerName") String var6, @BodyParam(value="application/json") ContainerExecRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/attach")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ContainerAttachResponseInner>> attach(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="containerGroupName") String var5, @PathParam(value="containerName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

