/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.LogAnalyticsLogType;
import java.io.IOException;
import java.util.Map;

public final class LogAnalytics
implements JsonSerializable<LogAnalytics> {
    private String workspaceId;
    private String workspaceKey;
    private LogAnalyticsLogType logType;
    private Map<String, String> metadata;
    private String workspaceResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(LogAnalytics.class);

    public String workspaceId() {
        return this.workspaceId;
    }

    public LogAnalytics withWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public String workspaceKey() {
        return this.workspaceKey;
    }

    public LogAnalytics withWorkspaceKey(String workspaceKey) {
        this.workspaceKey = workspaceKey;
        return this;
    }

    public LogAnalyticsLogType logType() {
        return this.logType;
    }

    public LogAnalytics withLogType(LogAnalyticsLogType logType) {
        this.logType = logType;
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public LogAnalytics withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String workspaceResourceId() {
        return this.workspaceResourceId;
    }

    public LogAnalytics withWorkspaceResourceId(String workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    public void validate() {
        if (this.workspaceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property workspaceId in model LogAnalytics"));
        }
        if (this.workspaceKey() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property workspaceKey in model LogAnalytics"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workspaceId", this.workspaceId);
        jsonWriter.writeStringField("workspaceKey", this.workspaceKey);
        jsonWriter.writeStringField("logType", this.logType == null ? null : this.logType.toString());
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("workspaceResourceId", this.workspaceResourceId);
        return jsonWriter.writeEndObject();
    }

    public static LogAnalytics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogAnalytics deserializedLogAnalytics = new LogAnalytics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("workspaceId".equals(fieldName)) {
                    deserializedLogAnalytics.workspaceId = reader.getString();
                    continue;
                }
                if ("workspaceKey".equals(fieldName)) {
                    deserializedLogAnalytics.workspaceKey = reader.getString();
                    continue;
                }
                if ("logType".equals(fieldName)) {
                    deserializedLogAnalytics.logType = LogAnalyticsLogType.fromString(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedLogAnalytics.metadata = metadata;
                    continue;
                }
                if ("workspaceResourceId".equals(fieldName)) {
                    deserializedLogAnalytics.workspaceResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogAnalytics;
        });
    }
}

