/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ScopeMapProperties
implements JsonSerializable<ScopeMapProperties> {
    private String description;
    private String type;
    private OffsetDateTime creationDate;
    private ProvisioningState provisioningState;
    private List<String> actions;
    private static final ClientLogger LOGGER = new ClientLogger(ScopeMapProperties.class);

    public String description() {
        return this.description;
    }

    public ScopeMapProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String type() {
        return this.type;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> actions() {
        return this.actions;
    }

    public ScopeMapProperties withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.actions() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property actions in model ScopeMapProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ScopeMapProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopeMapProperties deserializedScopeMapProperties = new ScopeMapProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actions".equals(fieldName)) {
                    List<String> actions = reader.readArray(reader1 -> reader1.getString());
                    deserializedScopeMapProperties.actions = actions;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedScopeMapProperties.description = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScopeMapProperties.type = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedScopeMapProperties.creationDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedScopeMapProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScopeMapProperties;
        });
    }
}

