/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.BaseImageDependency;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SetValue;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.StepType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import java.io.IOException;
import java.util.List;

public final class EncodedTaskStep
extends TaskStepProperties {
    private StepType type = StepType.ENCODED_TASK;
    private String encodedTaskContent;
    private String encodedValuesContent;
    private List<SetValue> values;
    private List<BaseImageDependency> baseImageDependencies;
    private static final ClientLogger LOGGER = new ClientLogger(EncodedTaskStep.class);

    @Override
    public StepType type() {
        return this.type;
    }

    public String encodedTaskContent() {
        return this.encodedTaskContent;
    }

    public EncodedTaskStep withEncodedTaskContent(String encodedTaskContent) {
        this.encodedTaskContent = encodedTaskContent;
        return this;
    }

    public String encodedValuesContent() {
        return this.encodedValuesContent;
    }

    public EncodedTaskStep withEncodedValuesContent(String encodedValuesContent) {
        this.encodedValuesContent = encodedValuesContent;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public EncodedTaskStep withValues(List<SetValue> values2) {
        this.values = values2;
        return this;
    }

    @Override
    public List<BaseImageDependency> baseImageDependencies() {
        return this.baseImageDependencies;
    }

    @Override
    public EncodedTaskStep withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    @Override
    public EncodedTaskStep withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.encodedTaskContent() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property encodedTaskContent in model EncodedTaskStep"));
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", this.contextPath());
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken());
        jsonWriter.writeStringField("encodedTaskContent", this.encodedTaskContent);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("encodedValuesContent", this.encodedValuesContent);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static EncodedTaskStep fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncodedTaskStep deserializedEncodedTaskStep = new EncodedTaskStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseImageDependencies".equals(fieldName)) {
                    List<BaseImageDependency> baseImageDependencies = reader.readArray(reader1 -> BaseImageDependency.fromJson(reader1));
                    deserializedEncodedTaskStep.baseImageDependencies = baseImageDependencies;
                    continue;
                }
                if ("contextPath".equals(fieldName)) {
                    deserializedEncodedTaskStep.withContextPath(reader.getString());
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedEncodedTaskStep.withContextAccessToken(reader.getString());
                    continue;
                }
                if ("encodedTaskContent".equals(fieldName)) {
                    deserializedEncodedTaskStep.encodedTaskContent = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEncodedTaskStep.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("encodedValuesContent".equals(fieldName)) {
                    deserializedEncodedTaskStep.encodedValuesContent = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List<SetValue> values2 = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    deserializedEncodedTaskStep.values = values2;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncodedTaskStep;
        });
    }
}

