/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.ContainerServiceSshPublicKey;
import java.io.IOException;
import java.util.List;

public final class ContainerServiceSshConfiguration
implements JsonSerializable<ContainerServiceSshConfiguration> {
    private List<ContainerServiceSshPublicKey> publicKeys;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerServiceSshConfiguration.class);

    public List<ContainerServiceSshPublicKey> publicKeys() {
        return this.publicKeys;
    }

    public ContainerServiceSshConfiguration withPublicKeys(List<ContainerServiceSshPublicKey> publicKeys) {
        this.publicKeys = publicKeys;
        return this;
    }

    public void validate() {
        if (this.publicKeys() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property publicKeys in model ContainerServiceSshConfiguration"));
        }
        this.publicKeys().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("publicKeys", this.publicKeys, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ContainerServiceSshConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerServiceSshConfiguration deserializedContainerServiceSshConfiguration = new ContainerServiceSshConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicKeys".equals(fieldName)) {
                    List<ContainerServiceSshPublicKey> publicKeys = reader.readArray(reader1 -> ContainerServiceSshPublicKey.fromJson(reader1));
                    deserializedContainerServiceSshConfiguration.publicKeys = publicKeys;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerServiceSshConfiguration;
        });
    }
}

