/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OSType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OpenShiftAgentPoolProfileRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OpenShiftContainerServiceVMSize;
import java.io.IOException;

public final class OpenShiftManagedClusterAgentPoolProfile
implements JsonSerializable<OpenShiftManagedClusterAgentPoolProfile> {
    private String name;
    private int count;
    private OpenShiftContainerServiceVMSize vmSize;
    private String subnetCidr;
    private OSType osType;
    private OpenShiftAgentPoolProfileRole role;
    private static final ClientLogger LOGGER = new ClientLogger(OpenShiftManagedClusterAgentPoolProfile.class);

    public String name() {
        return this.name;
    }

    public OpenShiftManagedClusterAgentPoolProfile withName(String name) {
        this.name = name;
        return this;
    }

    public int count() {
        return this.count;
    }

    public OpenShiftManagedClusterAgentPoolProfile withCount(int count) {
        this.count = count;
        return this;
    }

    public OpenShiftContainerServiceVMSize vmSize() {
        return this.vmSize;
    }

    public OpenShiftManagedClusterAgentPoolProfile withVmSize(OpenShiftContainerServiceVMSize vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public String subnetCidr() {
        return this.subnetCidr;
    }

    public OpenShiftManagedClusterAgentPoolProfile withSubnetCidr(String subnetCidr) {
        this.subnetCidr = subnetCidr;
        return this;
    }

    public OSType osType() {
        return this.osType;
    }

    public OpenShiftManagedClusterAgentPoolProfile withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    public OpenShiftAgentPoolProfileRole role() {
        return this.role;
    }

    public OpenShiftManagedClusterAgentPoolProfile withRole(OpenShiftAgentPoolProfileRole role) {
        this.role = role;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model OpenShiftManagedClusterAgentPoolProfile"));
        }
        if (this.vmSize() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property vmSize in model OpenShiftManagedClusterAgentPoolProfile"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeIntField("count", this.count);
        jsonWriter.writeStringField("vmSize", this.vmSize == null ? null : this.vmSize.toString());
        jsonWriter.writeStringField("subnetCidr", this.subnetCidr);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static OpenShiftManagedClusterAgentPoolProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenShiftManagedClusterAgentPoolProfile deserializedOpenShiftManagedClusterAgentPoolProfile = new OpenShiftManagedClusterAgentPoolProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterAgentPoolProfile.name = reader.getString();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterAgentPoolProfile.count = reader.getInt();
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterAgentPoolProfile.vmSize = OpenShiftContainerServiceVMSize.fromString(reader.getString());
                    continue;
                }
                if ("subnetCidr".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterAgentPoolProfile.subnetCidr = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterAgentPoolProfile.osType = OSType.fromString(reader.getString());
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterAgentPoolProfile.role = OpenShiftAgentPoolProfileRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenShiftManagedClusterAgentPoolProfile;
        });
    }
}

