/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.Type;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.WeekDay;
import java.io.IOException;

public final class RelativeMonthlySchedule
implements JsonSerializable<RelativeMonthlySchedule> {
    private int intervalMonths;
    private Type weekIndex;
    private WeekDay dayOfWeek;
    private static final ClientLogger LOGGER = new ClientLogger(RelativeMonthlySchedule.class);

    public int intervalMonths() {
        return this.intervalMonths;
    }

    public RelativeMonthlySchedule withIntervalMonths(int intervalMonths) {
        this.intervalMonths = intervalMonths;
        return this;
    }

    public Type weekIndex() {
        return this.weekIndex;
    }

    public RelativeMonthlySchedule withWeekIndex(Type weekIndex) {
        this.weekIndex = weekIndex;
        return this;
    }

    public WeekDay dayOfWeek() {
        return this.dayOfWeek;
    }

    public RelativeMonthlySchedule withDayOfWeek(WeekDay dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    public void validate() {
        if (this.weekIndex() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property weekIndex in model RelativeMonthlySchedule"));
        }
        if (this.dayOfWeek() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property dayOfWeek in model RelativeMonthlySchedule"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("intervalMonths", this.intervalMonths);
        jsonWriter.writeStringField("weekIndex", this.weekIndex == null ? null : this.weekIndex.toString());
        jsonWriter.writeStringField("dayOfWeek", this.dayOfWeek == null ? null : this.dayOfWeek.toString());
        return jsonWriter.writeEndObject();
    }

    public static RelativeMonthlySchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RelativeMonthlySchedule deserializedRelativeMonthlySchedule = new RelativeMonthlySchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("intervalMonths".equals(fieldName)) {
                    deserializedRelativeMonthlySchedule.intervalMonths = reader.getInt();
                    continue;
                }
                if ("weekIndex".equals(fieldName)) {
                    deserializedRelativeMonthlySchedule.weekIndex = Type.fromString(reader.getString());
                    continue;
                }
                if ("dayOfWeek".equals(fieldName)) {
                    deserializedRelativeMonthlySchedule.dayOfWeek = WeekDay.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRelativeMonthlySchedule;
        });
    }
}

