/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ClusterResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ManagedCassandraArmResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ManagedCassandraManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class ClusterResourceInner
extends ManagedCassandraArmResourceProperties {
    private ClusterResourceProperties properties;
    private String type;
    private String name;
    private String id;

    public ClusterResourceProperties properties() {
        return this.properties;
    }

    public ClusterResourceInner withProperties(ClusterResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ClusterResourceInner withIdentity(ManagedCassandraManagedServiceIdentity identity) {
        super.withIdentity(identity);
        return this;
    }

    @Override
    public ClusterResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ClusterResourceInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("identity", this.identity());
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ClusterResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterResourceInner deserializedClusterResourceInner = new ClusterResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClusterResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClusterResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClusterResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedClusterResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterResourceInner.withTags((Map)tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedClusterResourceInner.withIdentity(ManagedCassandraManagedServiceIdentity.fromJson(reader));
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClusterResourceInner.properties = ClusterResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterResourceInner;
        });
    }
}

