/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.AuthenticationMethodLdapProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CassandraError;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ManagedCassandraProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.SeedNode;
import java.io.IOException;
import java.util.List;

public final class DataCenterResourceProperties
implements JsonSerializable<DataCenterResourceProperties> {
    private ManagedCassandraProvisioningState provisioningState;
    private String dataCenterLocation;
    private String delegatedSubnetId;
    private Integer nodeCount;
    private List<SeedNode> seedNodes;
    private String base64EncodedCassandraYamlFragment;
    private String managedDiskCustomerKeyUri;
    private String backupStorageCustomerKeyUri;
    private String sku;
    private String diskSku;
    private Integer diskCapacity;
    private Boolean availabilityZone;
    private AuthenticationMethodLdapProperties authenticationMethodLdapProperties;
    private Boolean deallocated;
    private CassandraError provisionError;
    private String privateEndpointIpAddress;

    public ManagedCassandraProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DataCenterResourceProperties withProvisioningState(ManagedCassandraProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String dataCenterLocation() {
        return this.dataCenterLocation;
    }

    public DataCenterResourceProperties withDataCenterLocation(String dataCenterLocation) {
        this.dataCenterLocation = dataCenterLocation;
        return this;
    }

    public String delegatedSubnetId() {
        return this.delegatedSubnetId;
    }

    public DataCenterResourceProperties withDelegatedSubnetId(String delegatedSubnetId) {
        this.delegatedSubnetId = delegatedSubnetId;
        return this;
    }

    public Integer nodeCount() {
        return this.nodeCount;
    }

    public DataCenterResourceProperties withNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    public List<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public String base64EncodedCassandraYamlFragment() {
        return this.base64EncodedCassandraYamlFragment;
    }

    public DataCenterResourceProperties withBase64EncodedCassandraYamlFragment(String base64EncodedCassandraYamlFragment) {
        this.base64EncodedCassandraYamlFragment = base64EncodedCassandraYamlFragment;
        return this;
    }

    public String managedDiskCustomerKeyUri() {
        return this.managedDiskCustomerKeyUri;
    }

    public DataCenterResourceProperties withManagedDiskCustomerKeyUri(String managedDiskCustomerKeyUri) {
        this.managedDiskCustomerKeyUri = managedDiskCustomerKeyUri;
        return this;
    }

    public String backupStorageCustomerKeyUri() {
        return this.backupStorageCustomerKeyUri;
    }

    public DataCenterResourceProperties withBackupStorageCustomerKeyUri(String backupStorageCustomerKeyUri) {
        this.backupStorageCustomerKeyUri = backupStorageCustomerKeyUri;
        return this;
    }

    public String sku() {
        return this.sku;
    }

    public DataCenterResourceProperties withSku(String sku) {
        this.sku = sku;
        return this;
    }

    public String diskSku() {
        return this.diskSku;
    }

    public DataCenterResourceProperties withDiskSku(String diskSku) {
        this.diskSku = diskSku;
        return this;
    }

    public Integer diskCapacity() {
        return this.diskCapacity;
    }

    public DataCenterResourceProperties withDiskCapacity(Integer diskCapacity) {
        this.diskCapacity = diskCapacity;
        return this;
    }

    public Boolean availabilityZone() {
        return this.availabilityZone;
    }

    public DataCenterResourceProperties withAvailabilityZone(Boolean availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public AuthenticationMethodLdapProperties authenticationMethodLdapProperties() {
        return this.authenticationMethodLdapProperties;
    }

    public DataCenterResourceProperties withAuthenticationMethodLdapProperties(AuthenticationMethodLdapProperties authenticationMethodLdapProperties) {
        this.authenticationMethodLdapProperties = authenticationMethodLdapProperties;
        return this;
    }

    public Boolean deallocated() {
        return this.deallocated;
    }

    public DataCenterResourceProperties withDeallocated(Boolean deallocated) {
        this.deallocated = deallocated;
        return this;
    }

    public CassandraError provisionError() {
        return this.provisionError;
    }

    public DataCenterResourceProperties withProvisionError(CassandraError provisionError) {
        this.provisionError = provisionError;
        return this;
    }

    public String privateEndpointIpAddress() {
        return this.privateEndpointIpAddress;
    }

    public DataCenterResourceProperties withPrivateEndpointIpAddress(String privateEndpointIpAddress) {
        this.privateEndpointIpAddress = privateEndpointIpAddress;
        return this;
    }

    public void validate() {
        if (this.seedNodes() != null) {
            this.seedNodes().forEach(e -> e.validate());
        }
        if (this.authenticationMethodLdapProperties() != null) {
            this.authenticationMethodLdapProperties().validate();
        }
        if (this.provisionError() != null) {
            this.provisionError().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("dataCenterLocation", this.dataCenterLocation);
        jsonWriter.writeStringField("delegatedSubnetId", this.delegatedSubnetId);
        jsonWriter.writeNumberField("nodeCount", this.nodeCount);
        jsonWriter.writeStringField("base64EncodedCassandraYamlFragment", this.base64EncodedCassandraYamlFragment);
        jsonWriter.writeStringField("managedDiskCustomerKeyUri", this.managedDiskCustomerKeyUri);
        jsonWriter.writeStringField("backupStorageCustomerKeyUri", this.backupStorageCustomerKeyUri);
        jsonWriter.writeStringField("sku", this.sku);
        jsonWriter.writeStringField("diskSku", this.diskSku);
        jsonWriter.writeNumberField("diskCapacity", this.diskCapacity);
        jsonWriter.writeBooleanField("availabilityZone", this.availabilityZone);
        jsonWriter.writeJsonField("authenticationMethodLdapProperties", this.authenticationMethodLdapProperties);
        jsonWriter.writeBooleanField("deallocated", this.deallocated);
        jsonWriter.writeJsonField("provisionError", this.provisionError);
        jsonWriter.writeStringField("privateEndpointIpAddress", this.privateEndpointIpAddress);
        return jsonWriter.writeEndObject();
    }

    public static DataCenterResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataCenterResourceProperties deserializedDataCenterResourceProperties = new DataCenterResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.provisioningState = ManagedCassandraProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("dataCenterLocation".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.dataCenterLocation = reader.getString();
                    continue;
                }
                if ("delegatedSubnetId".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.delegatedSubnetId = reader.getString();
                    continue;
                }
                if ("nodeCount".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.nodeCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("seedNodes".equals(fieldName)) {
                    List<SeedNode> seedNodes = reader.readArray(reader1 -> SeedNode.fromJson(reader1));
                    deserializedDataCenterResourceProperties.seedNodes = seedNodes;
                    continue;
                }
                if ("base64EncodedCassandraYamlFragment".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.base64EncodedCassandraYamlFragment = reader.getString();
                    continue;
                }
                if ("managedDiskCustomerKeyUri".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.managedDiskCustomerKeyUri = reader.getString();
                    continue;
                }
                if ("backupStorageCustomerKeyUri".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.backupStorageCustomerKeyUri = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.sku = reader.getString();
                    continue;
                }
                if ("diskSku".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.diskSku = reader.getString();
                    continue;
                }
                if ("diskCapacity".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.diskCapacity = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.availabilityZone = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("authenticationMethodLdapProperties".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.authenticationMethodLdapProperties = AuthenticationMethodLdapProperties.fromJson(reader);
                    continue;
                }
                if ("deallocated".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.deallocated = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisionError".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.provisionError = CassandraError.fromJson(reader);
                    continue;
                }
                if ("privateEndpointIpAddress".equals(fieldName)) {
                    deserializedDataCenterResourceProperties.privateEndpointIpAddress = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataCenterResourceProperties;
        });
    }
}

