/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseRestoreResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.GremlinDatabaseRestoreResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.RestoreMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.RestoreParametersBase;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class RestoreParameters
extends RestoreParametersBase {
    private RestoreMode restoreMode;
    private List<DatabaseRestoreResource> databasesToRestore;
    private List<GremlinDatabaseRestoreResource> gremlinDatabasesToRestore;
    private List<String> tablesToRestore;

    public RestoreMode restoreMode() {
        return this.restoreMode;
    }

    public RestoreParameters withRestoreMode(RestoreMode restoreMode) {
        this.restoreMode = restoreMode;
        return this;
    }

    public List<DatabaseRestoreResource> databasesToRestore() {
        return this.databasesToRestore;
    }

    public RestoreParameters withDatabasesToRestore(List<DatabaseRestoreResource> databasesToRestore) {
        this.databasesToRestore = databasesToRestore;
        return this;
    }

    public List<GremlinDatabaseRestoreResource> gremlinDatabasesToRestore() {
        return this.gremlinDatabasesToRestore;
    }

    public RestoreParameters withGremlinDatabasesToRestore(List<GremlinDatabaseRestoreResource> gremlinDatabasesToRestore) {
        this.gremlinDatabasesToRestore = gremlinDatabasesToRestore;
        return this;
    }

    public List<String> tablesToRestore() {
        return this.tablesToRestore;
    }

    public RestoreParameters withTablesToRestore(List<String> tablesToRestore) {
        this.tablesToRestore = tablesToRestore;
        return this;
    }

    @Override
    public RestoreParameters withRestoreSource(String restoreSource) {
        super.withRestoreSource(restoreSource);
        return this;
    }

    @Override
    public RestoreParameters withRestoreTimestampInUtc(OffsetDateTime restoreTimestampInUtc) {
        super.withRestoreTimestampInUtc(restoreTimestampInUtc);
        return this;
    }

    @Override
    public RestoreParameters withRestoreWithTtlDisabled(Boolean restoreWithTtlDisabled) {
        super.withRestoreWithTtlDisabled(restoreWithTtlDisabled);
        return this;
    }

    @Override
    public void validate() {
        if (this.databasesToRestore() != null) {
            this.databasesToRestore().forEach(e -> e.validate());
        }
        if (this.gremlinDatabasesToRestore() != null) {
            this.gremlinDatabasesToRestore().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("restoreSource", this.restoreSource());
        jsonWriter.writeStringField("restoreTimestampInUtc", this.restoreTimestampInUtc() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restoreTimestampInUtc()));
        jsonWriter.writeBooleanField("restoreWithTtlDisabled", this.restoreWithTtlDisabled());
        jsonWriter.writeStringField("restoreMode", this.restoreMode == null ? null : this.restoreMode.toString());
        jsonWriter.writeArrayField("databasesToRestore", this.databasesToRestore, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("gremlinDatabasesToRestore", this.gremlinDatabasesToRestore, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("tablesToRestore", this.tablesToRestore, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static RestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestoreParameters deserializedRestoreParameters = new RestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restoreSource".equals(fieldName)) {
                    deserializedRestoreParameters.withRestoreSource(reader.getString());
                    continue;
                }
                if ("restoreTimestampInUtc".equals(fieldName)) {
                    deserializedRestoreParameters.withRestoreTimestampInUtc(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("restoreWithTtlDisabled".equals(fieldName)) {
                    deserializedRestoreParameters.withRestoreWithTtlDisabled(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("restoreMode".equals(fieldName)) {
                    deserializedRestoreParameters.restoreMode = RestoreMode.fromString(reader.getString());
                    continue;
                }
                if ("databasesToRestore".equals(fieldName)) {
                    List<DatabaseRestoreResource> databasesToRestore = reader.readArray(reader1 -> DatabaseRestoreResource.fromJson(reader1));
                    deserializedRestoreParameters.databasesToRestore = databasesToRestore;
                    continue;
                }
                if ("gremlinDatabasesToRestore".equals(fieldName)) {
                    List<GremlinDatabaseRestoreResource> gremlinDatabasesToRestore = reader.readArray(reader1 -> GremlinDatabaseRestoreResource.fromJson(reader1));
                    deserializedRestoreParameters.gremlinDatabasesToRestore = gremlinDatabasesToRestore;
                    continue;
                }
                if ("tablesToRestore".equals(fieldName)) {
                    List<String> tablesToRestore = reader.readArray(reader1 -> reader1.getString());
                    deserializedRestoreParameters.tablesToRestore = tablesToRestore;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreParameters;
        });
    }
}

