/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.DnsResourceReferencesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.models.DnsResourceReferenceResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsResourceReferenceRequest;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class DnsResourceReferencesClientImpl
implements DnsResourceReferencesClient {
    private final DnsResourceReferencesService service;
    private final DnsManagementClientImpl client;

    DnsResourceReferencesClientImpl(DnsManagementClientImpl client) {
        this.service = RestProxy.create(DnsResourceReferencesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DnsResourceReferenceResultInner>> getByTargetResourcesWithResponseAsync(DnsResourceReferenceRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByTargetResources(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DnsResourceReferenceResultInner>> getByTargetResourcesWithResponseAsync(DnsResourceReferenceRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByTargetResources(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DnsResourceReferenceResultInner> getByTargetResourcesAsync(DnsResourceReferenceRequest parameters) {
        return this.getByTargetResourcesWithResponseAsync(parameters).flatMap(res -> Mono.justOrEmpty((DnsResourceReferenceResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DnsResourceReferenceResultInner> getByTargetResourcesWithResponse(DnsResourceReferenceRequest parameters, Context context) {
        return this.getByTargetResourcesWithResponseAsync(parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResourceReferenceResultInner getByTargetResources(DnsResourceReferenceRequest parameters) {
        return this.getByTargetResourcesWithResponse(parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DnsManagementClientD")
    public static interface DnsResourceReferencesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/getDnsResourceReference")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResourceReferenceResultInner>> getByTargetResources(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") DnsResourceReferenceRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

