/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models.PrivateLinkResourceListResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation.KeysImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Keys;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsm;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.MhsmNetworkRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.PrivateEndpointServiceConnectionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.PrivateLinkServiceConnectionState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyServiceVersion;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class ManagedHsmImpl
extends GroupableResourceImpl<ManagedHsm, ManagedHsmInner, ManagedHsmImpl, KeyVaultManager>
implements ManagedHsm {
    private KeyAsyncClient keyClient;
    private final HttpPipeline mhsmHttpPipeline = ((KeyVaultManager)this.manager()).httpPipeline();

    ManagedHsmImpl(String name, ManagedHsmInner innerObject, KeyVaultManager manager) {
        super(name, innerObject, manager);
        if (((ManagedHsmInner)this.innerModel()).properties() != null && ((ManagedHsmInner)this.innerModel()).properties().hsmUri() != null) {
            this.keyClient = new KeyClientBuilder().pipeline(this.mhsmHttpPipeline).vaultUrl(((ManagedHsmInner)this.innerModel()).properties().hsmUri()).serviceVersion(KeyServiceVersion.V7_2).buildAsyncClient();
        }
    }

    @Override
    public Mono<ManagedHsm> createResourceAsync() {
        throw new UnsupportedOperationException("method [createResourceAsync] not implemented in class [com.azure.resourcemanager.keyvault.implementation.ManagedHsmImpl]");
    }

    @Override
    protected Mono<ManagedHsmInner> getInnerAsync() {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getManagedHsms().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public String tenantId() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null || ((ManagedHsmInner)this.innerModel()).properties().tenantId() == null) {
            return null;
        }
        return ((ManagedHsmInner)this.innerModel()).properties().tenantId().toString();
    }

    @Override
    public ManagedHsmSku sku() {
        return ((ManagedHsmInner)this.innerModel()).sku();
    }

    @Override
    public List<String> initialAdminObjectIds() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null || ((ManagedHsmInner)this.innerModel()).properties().initialAdminObjectIds() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((ManagedHsmInner)this.innerModel()).properties().initialAdminObjectIds());
    }

    @Override
    public String hsmUri() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)this.innerModel()).properties().hsmUri();
    }

    @Override
    public boolean isSoftDeleteEnabled() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean(((ManagedHsmInner)this.innerModel()).properties().enableSoftDelete());
    }

    @Override
    public Integer softDeleteRetentionInDays() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)this.innerModel()).properties().softDeleteRetentionInDays();
    }

    @Override
    public boolean isPurgeProtectionEnabled() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean(((ManagedHsmInner)this.innerModel()).properties().enablePurgeProtection());
    }

    @Override
    public MhsmNetworkRuleSet networkRuleSet() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)this.innerModel()).properties().networkAcls();
    }

    @Override
    public Keys keys() {
        return new KeysImpl(this.keyClient, this.mhsmHttpPipeline);
    }

    @Override
    public OffsetDateTime scheduledPurgeDate() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)this.innerModel()).properties().scheduledPurgeDate();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        if (((ManagedHsmInner)this.innerModel()).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)this.innerModel()).properties().publicNetworkAccess();
    }

    @Override
    public PagedIterable<PrivateLinkResource> listPrivateLinkResources() {
        return new PagedIterable<PrivateLinkResource>(this.listPrivateLinkResourcesAsync());
    }

    @Override
    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        Mono retList = ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateLinkResources().listByVaultWithResponseAsync(this.resourceGroupName(), this.name()).map(response -> new SimpleResponse((Response<?>)response, ((PrivateLinkResourceListResultInner)response.getValue()).value().stream().map(x$0 -> new PrivateLinkResourceImpl((com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.PrivateLinkResource)x$0)).collect(Collectors.toList())));
        return PagedConverter.convertListToPagedFlux(retList);
    }

    @Override
    public void approvePrivateEndpointConnection(String privateEndpointConnectionName) {
        this.approvePrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    @Override
    public Mono<Void> approvePrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateEndpointConnections().putAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionState().withStatus(PrivateEndpointServiceConnectionStatus.APPROVED))).then();
    }

    @Override
    public void rejectPrivateEndpointConnection(String privateEndpointConnectionName) {
        this.rejectPrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    @Override
    public Mono<Void> rejectPrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateEndpointConnections().putAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionState().withStatus(PrivateEndpointServiceConnectionStatus.REJECTED))).then();
    }

    private static final class PrivateLinkResourceImpl
    implements PrivateLinkResource {
        private final com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.PrivateLinkResource innerModel;

        private PrivateLinkResourceImpl(com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.PrivateLinkResource innerModel) {
            this.innerModel = innerModel;
        }

        @Override
        public String groupId() {
            return this.innerModel.groupId();
        }

        @Override
        public List<String> requiredMemberNames() {
            return Collections.unmodifiableList(this.innerModel.requiredMembers());
        }

        @Override
        public List<String> requiredDnsZoneNames() {
            return Collections.unmodifiableList(this.innerModel.requiredZoneNames());
        }
    }
}

