/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.ManagedHsmsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation.ManagedHsmImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsm;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsms;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.UUID;

public class ManagedHsmsImpl
extends GroupableResourcesImpl<ManagedHsm, ManagedHsmImpl, ManagedHsmInner, ManagedHsmsClient, KeyVaultManager>
implements ManagedHsms {
    private final String tenantId;

    public ManagedHsmsImpl(KeyVaultManager manager, String tenantId) {
        super(((KeyVaultManagementClient)manager.serviceClient()).getManagedHsms(), manager);
        this.tenantId = tenantId;
    }

    @Override
    protected ManagedHsmImpl wrapModel(String name) {
        ManagedHsmInner inner = new ManagedHsmInner().withProperties(new ManagedHsmProperties());
        inner.properties().withTenantId(UUID.fromString(this.tenantId));
        return new ManagedHsmImpl(name, inner, (KeyVaultManager)this.manager());
    }

    @Override
    protected Mono<ManagedHsmInner> getInnerAsync(String resourceGroupName, String name) {
        return ((ManagedHsmsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((ManagedHsmsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    @Override
    protected ManagedHsmImpl wrapModel(ManagedHsmInner inner) {
        if (inner == null) {
            return null;
        }
        return new ManagedHsmImpl(inner.name(), inner, (KeyVaultManager)this.manager());
    }

    @Override
    public PagedIterable<ManagedHsm> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<ManagedHsm>(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedFlux<ManagedHsm> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<ManagedHsm>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(((ManagedHsmsClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }
}

