/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.RetentionPolicy;
import java.io.IOException;
import java.util.List;

public final class LogProfileProperties
implements JsonSerializable<LogProfileProperties> {
    private String storageAccountId;
    private String serviceBusRuleId;
    private List<String> locations;
    private List<String> categories;
    private RetentionPolicy retentionPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(LogProfileProperties.class);

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public LogProfileProperties withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    public String serviceBusRuleId() {
        return this.serviceBusRuleId;
    }

    public LogProfileProperties withServiceBusRuleId(String serviceBusRuleId) {
        this.serviceBusRuleId = serviceBusRuleId;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public LogProfileProperties withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<String> categories() {
        return this.categories;
    }

    public LogProfileProperties withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    public LogProfileProperties withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public void validate() {
        if (this.locations() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property locations in model LogProfileProperties"));
        }
        if (this.categories() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property categories in model LogProfileProperties"));
        }
        if (this.retentionPolicy() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property retentionPolicy in model LogProfileProperties"));
        }
        this.retentionPolicy().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("retentionPolicy", this.retentionPolicy);
        jsonWriter.writeStringField("storageAccountId", this.storageAccountId);
        jsonWriter.writeStringField("serviceBusRuleId", this.serviceBusRuleId);
        return jsonWriter.writeEndObject();
    }

    public static LogProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogProfileProperties deserializedLogProfileProperties = new LogProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedLogProfileProperties.locations = locations;
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List<String> categories = reader.readArray(reader1 -> reader1.getString());
                    deserializedLogProfileProperties.categories = categories;
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    deserializedLogProfileProperties.retentionPolicy = RetentionPolicy.fromJson(reader);
                    continue;
                }
                if ("storageAccountId".equals(fieldName)) {
                    deserializedLogProfileProperties.storageAccountId = reader.getString();
                    continue;
                }
                if ("serviceBusRuleId".equals(fieldName)) {
                    deserializedLogProfileProperties.serviceBusRuleId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogProfileProperties;
        });
    }
}

