/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Patch;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.DataCollectionEndpointsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.DataCollectionEndpointResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DataCollectionEndpointResourceListResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ResourceForUpdate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class DataCollectionEndpointsClientImpl
implements InnerSupportsGet<DataCollectionEndpointResourceInner>,
InnerSupportsListing<DataCollectionEndpointResourceInner>,
InnerSupportsDelete<Void>,
DataCollectionEndpointsClient {
    private final DataCollectionEndpointsService service;
    private final MonitorClientImpl client;

    DataCollectionEndpointsClientImpl(MonitorClientImpl client) {
        this.service = RestProxy.create(DataCollectionEndpointsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionEndpointResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2021-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionEndpointResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionEndpointResourceListResult)res.getValue()).value(), ((DataCollectionEndpointResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionEndpointResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2021-09-01-preview", "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionEndpointResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionEndpointResourceListResult)res.getValue()).value(), ((DataCollectionEndpointResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataCollectionEndpointResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<DataCollectionEndpointResourceInner>(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataCollectionEndpointResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<DataCollectionEndpointResourceInner>(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionEndpointResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<DataCollectionEndpointResourceInner>(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionEndpointResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<DataCollectionEndpointResourceInner>(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionEndpointResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2021-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionEndpointResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionEndpointResourceListResult)res.getValue()).value(), ((DataCollectionEndpointResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionEndpointResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2021-09-01-preview", "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionEndpointResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionEndpointResourceListResult)res.getValue()).value(), ((DataCollectionEndpointResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataCollectionEndpointResourceInner> listAsync() {
        return new PagedFlux<DataCollectionEndpointResourceInner>(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataCollectionEndpointResourceInner> listAsync(Context context) {
        return new PagedFlux<DataCollectionEndpointResourceInner>(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionEndpointResourceInner> list() {
        return new PagedIterable<DataCollectionEndpointResourceInner>(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionEndpointResourceInner> list(Context context) {
        return new PagedIterable<DataCollectionEndpointResourceInner>(this.listAsync(context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataCollectionEndpointResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String dataCollectionEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataCollectionEndpointResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String dataCollectionEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataCollectionEndpointResourceInner> getByResourceGroupAsync(String resourceGroupName, String dataCollectionEndpointName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, dataCollectionEndpointName).flatMap(res -> Mono.justOrEmpty((DataCollectionEndpointResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataCollectionEndpointResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String dataCollectionEndpointName, Context context) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, dataCollectionEndpointName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataCollectionEndpointResourceInner getByResourceGroup(String resourceGroupName, String dataCollectionEndpointName) {
        return this.getByResourceGroupWithResponse(resourceGroupName, dataCollectionEndpointName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataCollectionEndpointResourceInner>> createWithResponseAsync(String resourceGroupName, String dataCollectionEndpointName, DataCollectionEndpointResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataCollectionEndpointResourceInner>> createWithResponseAsync(String resourceGroupName, String dataCollectionEndpointName, DataCollectionEndpointResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataCollectionEndpointResourceInner> createAsync(String resourceGroupName, String dataCollectionEndpointName) {
        DataCollectionEndpointResourceInner body = null;
        return this.createWithResponseAsync(resourceGroupName, dataCollectionEndpointName, body).flatMap(res -> Mono.justOrEmpty((DataCollectionEndpointResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataCollectionEndpointResourceInner> createWithResponse(String resourceGroupName, String dataCollectionEndpointName, DataCollectionEndpointResourceInner body, Context context) {
        return this.createWithResponseAsync(resourceGroupName, dataCollectionEndpointName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataCollectionEndpointResourceInner create(String resourceGroupName, String dataCollectionEndpointName) {
        DataCollectionEndpointResourceInner body = null;
        return this.createWithResponse(resourceGroupName, dataCollectionEndpointName, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataCollectionEndpointResourceInner>> updateWithResponseAsync(String resourceGroupName, String dataCollectionEndpointName, ResourceForUpdate body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataCollectionEndpointResourceInner>> updateWithResponseAsync(String resourceGroupName, String dataCollectionEndpointName, ResourceForUpdate body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataCollectionEndpointResourceInner> updateAsync(String resourceGroupName, String dataCollectionEndpointName) {
        ResourceForUpdate body = null;
        return this.updateWithResponseAsync(resourceGroupName, dataCollectionEndpointName, body).flatMap(res -> Mono.justOrEmpty((DataCollectionEndpointResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataCollectionEndpointResourceInner> updateWithResponse(String resourceGroupName, String dataCollectionEndpointName, ResourceForUpdate body, Context context) {
        return this.updateWithResponseAsync(resourceGroupName, dataCollectionEndpointName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataCollectionEndpointResourceInner update(String resourceGroupName, String dataCollectionEndpointName) {
        ResourceForUpdate body = null;
        return this.updateWithResponse(resourceGroupName, dataCollectionEndpointName, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String dataCollectionEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String dataCollectionEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String dataCollectionEndpointName) {
        return this.deleteWithResponseAsync(resourceGroupName, dataCollectionEndpointName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String dataCollectionEndpointName, Context context) {
        return this.deleteWithResponseAsync(resourceGroupName, dataCollectionEndpointName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dataCollectionEndpointName) {
        this.deleteWithResponse(resourceGroupName, dataCollectionEndpointName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionEndpointResourceInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionEndpointResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionEndpointResourceListResult)res.getValue()).value(), ((DataCollectionEndpointResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionEndpointResourceInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionEndpointResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionEndpointResourceListResult)res.getValue()).value(), ((DataCollectionEndpointResourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionEndpointResourceInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionEndpointResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionEndpointResourceListResult)res.getValue()).value(), ((DataCollectionEndpointResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionEndpointResourceInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionEndpointResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionEndpointResourceListResult)res.getValue()).value(), ((DataCollectionEndpointResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientDataCol")
    public static interface DataCollectionEndpointsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionEndpointResourceListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/dataCollectionEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionEndpointResourceListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints/{dataCollectionEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionEndpointResourceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dataCollectionEndpointName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints/{dataCollectionEndpointName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionEndpointResourceInner>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dataCollectionEndpointName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") DataCollectionEndpointResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints/{dataCollectionEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionEndpointResourceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dataCollectionEndpointName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ResourceForUpdate var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints/{dataCollectionEndpointName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dataCollectionEndpointName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionEndpointResourceListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionEndpointResourceListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

