/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VpnConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VpnGatewayNatRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.BgpSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VpnGatewayIpConfiguration;
import java.io.IOException;
import java.util.List;

public final class VpnGatewayProperties
implements JsonSerializable<VpnGatewayProperties> {
    private SubResource virtualHub;
    private List<VpnConnectionInner> connections;
    private BgpSettings bgpSettings;
    private ProvisioningState provisioningState;
    private Integer vpnGatewayScaleUnit;
    private List<VpnGatewayIpConfiguration> ipConfigurations;
    private Boolean enableBgpRouteTranslationForNat;
    private Boolean isRoutingPreferenceInternet;
    private List<VpnGatewayNatRuleInner> natRules;

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public VpnGatewayProperties withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<VpnConnectionInner> connections() {
        return this.connections;
    }

    public VpnGatewayProperties withConnections(List<VpnConnectionInner> connections) {
        this.connections = connections;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public VpnGatewayProperties withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer vpnGatewayScaleUnit() {
        return this.vpnGatewayScaleUnit;
    }

    public VpnGatewayProperties withVpnGatewayScaleUnit(Integer vpnGatewayScaleUnit) {
        this.vpnGatewayScaleUnit = vpnGatewayScaleUnit;
        return this;
    }

    public List<VpnGatewayIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public Boolean enableBgpRouteTranslationForNat() {
        return this.enableBgpRouteTranslationForNat;
    }

    public VpnGatewayProperties withEnableBgpRouteTranslationForNat(Boolean enableBgpRouteTranslationForNat) {
        this.enableBgpRouteTranslationForNat = enableBgpRouteTranslationForNat;
        return this;
    }

    public Boolean isRoutingPreferenceInternet() {
        return this.isRoutingPreferenceInternet;
    }

    public VpnGatewayProperties withIsRoutingPreferenceInternet(Boolean isRoutingPreferenceInternet) {
        this.isRoutingPreferenceInternet = isRoutingPreferenceInternet;
        return this;
    }

    public List<VpnGatewayNatRuleInner> natRules() {
        return this.natRules;
    }

    public VpnGatewayProperties withNatRules(List<VpnGatewayNatRuleInner> natRules) {
        this.natRules = natRules;
        return this;
    }

    public void validate() {
        if (this.connections() != null) {
            this.connections().forEach(e -> e.validate());
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.natRules() != null) {
            this.natRules().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualHub", this.virtualHub);
        jsonWriter.writeArrayField("connections", this.connections, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("bgpSettings", this.bgpSettings);
        jsonWriter.writeNumberField("vpnGatewayScaleUnit", this.vpnGatewayScaleUnit);
        jsonWriter.writeBooleanField("enableBgpRouteTranslationForNat", this.enableBgpRouteTranslationForNat);
        jsonWriter.writeBooleanField("isRoutingPreferenceInternet", this.isRoutingPreferenceInternet);
        jsonWriter.writeArrayField("natRules", this.natRules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static VpnGatewayProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnGatewayProperties deserializedVpnGatewayProperties = new VpnGatewayProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualHub".equals(fieldName)) {
                    deserializedVpnGatewayProperties.virtualHub = SubResource.fromJson(reader);
                    continue;
                }
                if ("connections".equals(fieldName)) {
                    List<VpnConnectionInner> connections = reader.readArray(reader1 -> VpnConnectionInner.fromJson(reader1));
                    deserializedVpnGatewayProperties.connections = connections;
                    continue;
                }
                if ("bgpSettings".equals(fieldName)) {
                    deserializedVpnGatewayProperties.bgpSettings = BgpSettings.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVpnGatewayProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("vpnGatewayScaleUnit".equals(fieldName)) {
                    deserializedVpnGatewayProperties.vpnGatewayScaleUnit = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List<VpnGatewayIpConfiguration> ipConfigurations = reader.readArray(reader1 -> VpnGatewayIpConfiguration.fromJson(reader1));
                    deserializedVpnGatewayProperties.ipConfigurations = ipConfigurations;
                    continue;
                }
                if ("enableBgpRouteTranslationForNat".equals(fieldName)) {
                    deserializedVpnGatewayProperties.enableBgpRouteTranslationForNat = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isRoutingPreferenceInternet".equals(fieldName)) {
                    deserializedVpnGatewayProperties.isRoutingPreferenceInternet = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("natRules".equals(fieldName)) {
                    List<VpnGatewayNatRuleInner> natRules = reader.readArray(reader1 -> VpnGatewayNatRuleInner.fromJson(reader1));
                    deserializedVpnGatewayProperties.natRules = natRules;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnGatewayProperties;
        });
    }
}

