/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressSpace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AppliableWithTags;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.BgpSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LocalNetworkGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TagsObject;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class LocalNetworkGatewayImpl
extends GroupableResourceImpl<LocalNetworkGateway, LocalNetworkGatewayInner, LocalNetworkGatewayImpl, NetworkManager>
implements LocalNetworkGateway,
LocalNetworkGateway.Definition,
LocalNetworkGateway.Update,
AppliableWithTags<LocalNetworkGateway> {
    LocalNetworkGatewayImpl(String name, LocalNetworkGatewayInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    @Override
    public String ipAddress() {
        return ((LocalNetworkGatewayInner)this.innerModel()).gatewayIpAddress();
    }

    @Override
    public BgpSettings bgpSettings() {
        return ((LocalNetworkGatewayInner)this.innerModel()).bgpSettings();
    }

    @Override
    public Set<String> addressSpaces() {
        HashSet<String> addressSpaces = new HashSet<String>();
        if (((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace() != null && ((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace().addressPrefixes() != null) {
            addressSpaces.addAll(((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace().addressPrefixes());
        }
        return Collections.unmodifiableSet(addressSpaces);
    }

    @Override
    public String provisioningState() {
        return ((LocalNetworkGatewayInner)this.innerModel()).provisioningState().toString();
    }

    @Override
    public LocalNetworkGatewayImpl withIPAddress(String ipAddress) {
        ((LocalNetworkGatewayInner)this.innerModel()).withGatewayIpAddress(ipAddress);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withAddressSpace(String cidr) {
        if (((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace() == null) {
            ((LocalNetworkGatewayInner)this.innerModel()).withLocalNetworkAddressSpace(new AddressSpace());
        }
        if (((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace().addressPrefixes() == null) {
            ((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace().withAddressPrefixes(new ArrayList<String>());
        }
        ((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace().addressPrefixes().add(cidr);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withoutAddressSpace(String cidr) {
        if (((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace() == null || ((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace().addressPrefixes() == null) {
            return this;
        }
        ((LocalNetworkGatewayInner)this.innerModel()).localNetworkAddressSpace().addressPrefixes().remove(cidr);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withBgp(long asn, String bgpPeeringAddress) {
        this.ensureBgpSettings().withAsn(asn).withBgpPeeringAddress(bgpPeeringAddress);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withoutBgp() {
        ((LocalNetworkGatewayInner)this.innerModel()).withBgpSettings(null);
        return this;
    }

    @Override
    protected Mono<LocalNetworkGatewayInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLocalNetworkGateways().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<LocalNetworkGateway> createResourceAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLocalNetworkGateways().createOrUpdateAsync(this.resourceGroupName(), this.name(), (LocalNetworkGatewayInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    private BgpSettings ensureBgpSettings() {
        if (((LocalNetworkGatewayInner)this.innerModel()).bgpSettings() == null) {
            ((LocalNetworkGatewayInner)this.innerModel()).withBgpSettings(new BgpSettings());
        }
        return ((LocalNetworkGatewayInner)this.innerModel()).bgpSettings();
    }

    public LocalNetworkGatewayImpl updateTags() {
        return this;
    }

    @Override
    public LocalNetworkGateway applyTags() {
        return this.applyTagsAsync().block();
    }

    @Override
    public Mono<LocalNetworkGateway> applyTagsAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLocalNetworkGateways().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((LocalNetworkGatewayInner)this.innerModel()).tags())).flatMap(inner -> {
            this.setInner(inner);
            return Mono.just(this);
        });
    }
}

