/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ContainerNetworkInterfaceConfigurationPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.IpConfigurationProfileInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ContainerNetworkInterfaceConfiguration
extends SubResource {
    private ContainerNetworkInterfaceConfigurationPropertiesFormat innerProperties;
    private String name;
    private String type;
    private String etag;

    private ContainerNetworkInterfaceConfigurationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ContainerNetworkInterfaceConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public ContainerNetworkInterfaceConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public List<IpConfigurationProfileInner> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public ContainerNetworkInterfaceConfiguration withIpConfigurations(List<IpConfigurationProfileInner> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerNetworkInterfaceConfigurationPropertiesFormat();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public List<SubResource> containerNetworkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaces();
    }

    public ContainerNetworkInterfaceConfiguration withContainerNetworkInterfaces(List<SubResource> containerNetworkInterfaces) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerNetworkInterfaceConfigurationPropertiesFormat();
        }
        this.innerProperties().withContainerNetworkInterfaces(containerNetworkInterfaces);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ContainerNetworkInterfaceConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerNetworkInterfaceConfiguration deserializedContainerNetworkInterfaceConfiguration = new ContainerNetworkInterfaceConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerNetworkInterfaceConfiguration.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedContainerNetworkInterfaceConfiguration.innerProperties = ContainerNetworkInterfaceConfigurationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainerNetworkInterfaceConfiguration.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerNetworkInterfaceConfiguration.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedContainerNetworkInterfaceConfiguration.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerNetworkInterfaceConfiguration;
        });
    }
}

