/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.fluent.models.PrivateZoneProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class PrivateZoneInner
extends Resource {
    private String etag;
    private PrivateZoneProperties innerProperties;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateZoneInner.class);

    public String etag() {
        return this.etag;
    }

    public PrivateZoneInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    private PrivateZoneProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public PrivateZoneInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public PrivateZoneInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Long maxNumberOfRecordSets() {
        return this.innerProperties() == null ? null : this.innerProperties().maxNumberOfRecordSets();
    }

    public Long numberOfRecordSets() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfRecordSets();
    }

    public Long maxNumberOfVirtualNetworkLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().maxNumberOfVirtualNetworkLinks();
    }

    public Long numberOfVirtualNetworkLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfVirtualNetworkLinks();
    }

    public Long maxNumberOfVirtualNetworkLinksWithRegistration() {
        return this.innerProperties() == null ? null : this.innerProperties().maxNumberOfVirtualNetworkLinksWithRegistration();
    }

    public Long numberOfVirtualNetworkLinksWithRegistration() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfVirtualNetworkLinksWithRegistration();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String internalId() {
        return this.innerProperties() == null ? null : this.innerProperties().internalId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.location() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property location in model PrivateZoneInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PrivateZoneInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateZoneInner deserializedPrivateZoneInner = new PrivateZoneInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateZoneInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateZoneInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateZoneInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPrivateZoneInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPrivateZoneInner.withTags((Map)tags);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPrivateZoneInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateZoneInner.innerProperties = PrivateZoneProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateZoneInner;
        });
    }
}

