/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.DeploymentProperties;
import java.io.IOException;
import java.util.Map;

public final class DeploymentInner
implements JsonSerializable<DeploymentInner> {
    private String location;
    private DeploymentProperties properties;
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentInner.class);

    public String location() {
        return this.location;
    }

    public DeploymentInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public DeploymentProperties properties() {
        return this.properties;
    }

    public DeploymentInner withProperties(DeploymentProperties properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DeploymentInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property properties in model DeploymentInner"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static DeploymentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentInner deserializedDeploymentInner = new DeploymentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDeploymentInner.properties = DeploymentProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDeploymentInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeploymentInner.tags = tags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentInner;
        });
    }
}

