/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.collection.SupportsBatchCreation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.CreatedResources;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CreatableResourcesImpl<T extends Indexable, ImplT extends T, InnerT>
extends CreatableWrappersImpl<T, ImplT, InnerT>
implements SupportsBatchCreation<T> {
    protected CreatableResourcesImpl() {
    }

    @Override
    @SafeVarargs
    public final CreatedResources<T> create(Creatable<T> ... creatables) {
        return this.createAsyncNonStream(creatables).block();
    }

    @Override
    public final CreatedResources<T> create(List<? extends Creatable<T>> creatables) {
        return this.createAsyncNonStream(creatables).block();
    }

    @Override
    public final Flux<T> createAsync(Creatable<T> ... creatables) {
        return this.createAsync((List<? extends Creatable<T>>)Arrays.asList(creatables));
    }

    @Override
    public final Flux<T> createAsync(List<? extends Creatable<T>> creatables) {
        if (creatables == null) {
            return Flux.empty();
        }
        return this.createWithRootResourceAsync(creatables).flatMapMany(rootResource -> Flux.fromIterable(rootResource.createdTopLevelResources()));
    }

    private Mono<CreatedResources<T>> createAsyncNonStream(List<? extends Creatable<T>> creatables) {
        return this.createWithRootResourceAsync(creatables).map(x$0 -> new CreatedResourcesImpl(x$0));
    }

    private Mono<CreatedResources<T>> createAsyncNonStream(Creatable<T> ... creatables) {
        return this.createAsyncNonStream(Arrays.asList(creatables));
    }

    private Mono<CreatableUpdatableResourcesRoot<T>> createWithRootResourceAsync(List<? extends Creatable<T>> creatables) {
        CreatableUpdatableResourcesRootImpl rootResource = new CreatableUpdatableResourcesRootImpl();
        rootResource.addCreatableDependencies(creatables);
        return rootResource.createAsync();
    }

    private class CreatableUpdatableResourcesRootImpl<ResourceT extends Indexable>
    extends CreatableUpdatableImpl<CreatableUpdatableResourcesRoot<ResourceT>, Object, CreatableUpdatableResourcesRootImpl<ResourceT>>
    implements CreatableUpdatableResourcesRoot<ResourceT> {
        private List<String> keys;

        CreatableUpdatableResourcesRootImpl() {
            super("CreatableUpdatableResourcesRoot", null);
            this.keys = new ArrayList<String>();
        }

        @Override
        public List<ResourceT> createdTopLevelResources() {
            ArrayList resources = new ArrayList();
            for (String resourceKey : this.keys) {
                resources.add(this.taskResult(resourceKey));
            }
            return Collections.unmodifiableList(resources);
        }

        @Override
        public Indexable createdRelatedResource(String key) {
            return this.taskResult(key);
        }

        void addCreatableDependencies(Creatable<T> ... creatables) {
            for (Creatable item : creatables) {
                this.keys.add(this.addDependency(item));
            }
        }

        void addCreatableDependencies(List<? extends Creatable<T>> creatables) {
            for (Creatable item : creatables) {
                this.keys.add(this.addDependency(item));
            }
        }

        @Override
        public Mono<CreatableUpdatableResourcesRoot<ResourceT>> createResourceAsync() {
            return Mono.just(this);
        }

        @Override
        public Mono<CreatableUpdatableResourcesRoot<ResourceT>> updateResourceAsync() {
            return this.createResourceAsync();
        }

        @Override
        public boolean isInCreateMode() {
            return true;
        }

        @Override
        protected Mono<Object> getInnerAsync() {
            return null;
        }
    }

    private class CreatedResourcesImpl<ResourceT extends Indexable>
    implements CreatedResources<ResourceT> {
        private final ClientLogger logger = new ClientLogger(this.getClass());
        private CreatableUpdatableResourcesRoot<ResourceT> creatableUpdatableResourcesRoot;
        private Map<String, ResourceT> resources = new HashMap<String, ResourceT>();

        CreatedResourcesImpl(CreatableUpdatableResourcesRoot<ResourceT> creatableUpdatableResourcesRoot) {
            this.creatableUpdatableResourcesRoot = creatableUpdatableResourcesRoot;
            for (Indexable resource : this.creatableUpdatableResourcesRoot.createdTopLevelResources()) {
                this.resources.put(resource.key(), resource);
            }
        }

        @Override
        public Indexable createdRelatedResource(String key) {
            return this.creatableUpdatableResourcesRoot.createdRelatedResource(key);
        }

        @Override
        public void clear() {
            throw this.logger.logExceptionAsError(new UnsupportedOperationException());
        }

        @Override
        public Set<String> keySet() {
            return this.resources.keySet();
        }

        @Override
        public Collection<ResourceT> values() {
            return this.resources.values();
        }

        @Override
        public Set<Map.Entry<String, ResourceT>> entrySet() {
            return this.resources.entrySet();
        }

        @Override
        public int size() {
            return this.resources.size();
        }

        @Override
        public boolean isEmpty() {
            return this.resources.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.resources.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.resources.containsValue(value);
        }

        @Override
        public ResourceT get(Object key) {
            return (ResourceT)((Indexable)this.resources.get(key));
        }

        @Override
        public ResourceT put(String key, ResourceT value) {
            throw this.logger.logExceptionAsError(new UnsupportedOperationException());
        }

        @Override
        public ResourceT remove(Object key) {
            throw this.logger.logExceptionAsError(new UnsupportedOperationException());
        }

        @Override
        public void putAll(Map<? extends String, ? extends ResourceT> m) {
            throw this.logger.logExceptionAsError(new UnsupportedOperationException());
        }
    }

    static interface CreatableUpdatableResourcesRoot<ResourceT extends Indexable>
    extends Indexable {
        public List<ResourceT> createdTopLevelResources();

        public Indexable createdRelatedResource(String var1);
    }
}

