/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementError;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollerFactory;
import com.dataiku.dss.shadelibazure.com.azure.core.management.serializer.SerializerFactory;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerEncoding;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.rest.ActivationResponse;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AcceptedImpl<InnerT, T>
implements Accepted<T> {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final Response<Flux<ByteBuffer>> activationResponse;
    private byte[] responseBytes;
    private final SerializerAdapter serializerAdapter;
    private final HttpPipeline httpPipeline;
    private final Duration defaultPollInterval;
    private final Type pollResultType;
    private final Type finalResultType;
    private final Function<InnerT, T> wrapOperation;
    private final Context context;
    private PollerFlux<PollResult<InnerT>, InnerT> pollerFlux;
    private SyncPoller<Void, T> syncPoller;

    public AcceptedImpl(Response<Flux<ByteBuffer>> activationResponse, SerializerAdapter serializerAdapter, HttpPipeline httpPipeline, Duration defaultPollInterval, Type pollResultType, Type finalResultType, Function<InnerT, T> wrapOperation, Context context) {
        this.activationResponse = Objects.requireNonNull(activationResponse);
        this.serializerAdapter = Objects.requireNonNull(serializerAdapter);
        this.httpPipeline = Objects.requireNonNull(httpPipeline);
        this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval);
        this.pollResultType = Objects.requireNonNull(pollResultType);
        this.finalResultType = Objects.requireNonNull(finalResultType);
        this.wrapOperation = Objects.requireNonNull(wrapOperation);
        this.context = context;
    }

    @Override
    public ActivationResponse<T> getActivationResponse() {
        try {
            T value = this.wrapOperation.apply(this.serializerAdapter.deserialize(new String(this.getResponse(), StandardCharsets.UTF_8), this.finalResultType, SerializerEncoding.JSON));
            Duration retryAfter = AcceptedImpl.getRetryAfter(this.activationResponse.getHeaders());
            return new ActivationResponse<T>(this.activationResponse.getRequest(), this.activationResponse.getStatusCode(), this.activationResponse.getHeaders(), value, this.getActivationResponseStatus(), retryAfter);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new IllegalStateException("Failed to deserialize activation response body", e));
        }
    }

    @Override
    public SyncPoller<Void, T> getSyncPoller() {
        if (this.syncPoller == null) {
            Function errorOperation = response -> {
                String errorMessage;
                ManagementError managementError = null;
                HttpResponseImpl errorResponse = null;
                PollResult.Error lroError = ((PollResult)response.getValue()).getError();
                if (((PollResult)response.getValue()).getError() != null) {
                    errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                    errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                    String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                    if (errorBody != null) {
                        try {
                            managementError = (ManagementError)this.serializerAdapter.deserialize(errorBody, (Type)((Object)ManagementError.class), SerializerEncoding.JSON);
                            if (managementError.getCode() == null || managementError.getMessage() == null) {
                                managementError = null;
                            }
                        }
                        catch (IOException | RuntimeException ioe) {
                            this.logger.logThrowableAsWarning(ioe);
                        }
                    }
                } else {
                    errorMessage = "Long running operation failed.";
                }
                if (managementError == null) {
                    managementError = new ManagementError(response.getStatus().toString(), errorMessage);
                }
                return new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError);
            };
            this.syncPoller = new SyncPollerImpl<InnerT, T>(this.getPollerFlux().getSyncPoller(), this.wrapOperation, errorOperation);
        }
        return this.syncPoller;
    }

    private PollerFlux<PollResult<InnerT>, InnerT> getPollerFlux() {
        if (this.pollerFlux == null) {
            Flux<ByteBuffer> content = Flux.just(ByteBuffer.wrap(this.getResponse()));
            SimpleResponse<Flux<ByteBuffer>> clonedResponse = new SimpleResponse<Flux<ByteBuffer>>(this.activationResponse, content);
            this.pollerFlux = PollerFactory.create(this.serializerAdapter, this.httpPipeline, this.pollResultType, this.finalResultType, this.defaultPollInterval, Mono.just(clonedResponse), this.context);
        }
        return this.pollerFlux;
    }

    @Override
    public T getFinalResult() {
        return this.getSyncPoller().getFinalResult();
    }

    private LongRunningOperationStatus getActivationResponseStatus() {
        String responseBody = new String(this.getResponse(), StandardCharsets.UTF_8);
        String provisioningState = null;
        if (!CoreUtils.isNullOrEmpty(responseBody)) {
            try {
                ResourceWithProvisioningState resource = (ResourceWithProvisioningState)this.serializerAdapter.deserialize(responseBody, (Type)((Object)ResourceWithProvisioningState.class), SerializerEncoding.JSON);
                provisioningState = resource != null ? resource.getProvisioningState() : null;
            }
            catch (IOException resource) {
                // empty catch block
            }
        }
        LongRunningOperationStatus status = LongRunningOperationStatus.IN_PROGRESS;
        if (!CoreUtils.isNullOrEmpty(provisioningState)) {
            status = AcceptedImpl.toLongRunningOperationStatus(provisioningState);
        } else {
            int statusCode = this.activationResponse.getStatusCode();
            if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
            }
        }
        return status;
    }

    private static LongRunningOperationStatus toLongRunningOperationStatus(String value) {
        if ("Succeeded".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
        }
        if ("Failed".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.FAILED;
        }
        if ("Canceled".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.USER_CANCELLED;
        }
        if ("InProgress".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.IN_PROGRESS;
        }
        return LongRunningOperationStatus.fromString(value, false);
    }

    private static Duration getRetryAfter(HttpHeaders headers) {
        String value;
        if (headers != null && (value = headers.getValue("Retry-After")) != null) {
            return Duration.ofSeconds(Long.parseLong(value));
        }
        return null;
    }

    private byte[] getResponse() {
        if (this.responseBytes == null) {
            this.responseBytes = FluxUtil.collectBytesInByteBufferStream(this.activationResponse.getValue()).block();
        }
        return this.responseBytes;
    }

    public static <T, InnerT> Accepted<T> newAccepted(ClientLogger logger, HttpPipeline httpPipeline, Duration pollInterval, Supplier<Response<Flux<ByteBuffer>>> activationOperation, Function<InnerT, T> convertOperation, Type innerType, Runnable preActivation, Context context) {
        Response<Flux<ByteBuffer>> activationResponse;
        if (preActivation != null) {
            preActivation.run();
        }
        if ((activationResponse = activationOperation.get()) == null) {
            throw logger.logExceptionAsError(new NullPointerException());
        }
        AcceptedImpl<InnerT, T> accepted = new AcceptedImpl<InnerT, T>(activationResponse, SerializerFactory.createDefaultManagementSerializerAdapter(), httpPipeline, ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(pollInterval), innerType, innerType, convertOperation, context);
        return accepted;
    }

    public static <T extends HasInnerModel<InnerT>, InnerT> Accepted<T> newAccepted(ClientLogger logger, HttpPipeline httpPipeline, Duration pollInterval, Supplier<Response<Flux<ByteBuffer>>> activationOperation, Function<InnerT, T> convertOperation, Type innerType, Runnable preActivation, Consumer<InnerT> postActivation, Context context) {
        Response<Flux<ByteBuffer>> activationResponse;
        if (preActivation != null) {
            preActivation.run();
        }
        if ((activationResponse = activationOperation.get()) == null) {
            throw logger.logExceptionAsError(new NullPointerException());
        }
        AcceptedImpl<InnerT, T> accepted = new AcceptedImpl<InnerT, T>(activationResponse, SerializerFactory.createDefaultManagementSerializerAdapter(), httpPipeline, ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(pollInterval), innerType, innerType, convertOperation, context);
        if (postActivation != null) {
            postActivation.accept(((HasInnerModel)accepted.getActivationResponse().getValue()).innerModel());
        }
        return accepted;
    }

    private static class SyncPollerImpl<InnerT, T>
    implements SyncPoller<Void, T> {
        private final SyncPoller<PollResult<InnerT>, InnerT> syncPoller;
        private final Function<InnerT, T> wrapOperation;
        private final Function<PollResponse<PollResult<InnerT>>, ManagementException> errorOperation;
        private T finalResult;
        private ManagementException exception;

        SyncPollerImpl(SyncPoller<PollResult<InnerT>, InnerT> syncPoller, Function<InnerT, T> wrapOperation, Function<PollResponse<PollResult<InnerT>>, ManagementException> errorOperation) {
            this.syncPoller = syncPoller;
            this.wrapOperation = wrapOperation;
            this.errorOperation = errorOperation;
        }

        @Override
        public PollResponse<Void> poll() {
            return this.voidResponse(this.syncPoller.poll());
        }

        @Override
        public PollResponse<Void> waitForCompletion() {
            return this.voidResponse(this.syncPoller.waitForCompletion());
        }

        @Override
        public PollResponse<Void> waitForCompletion(Duration duration) {
            return this.voidResponse(this.syncPoller.waitForCompletion(duration));
        }

        @Override
        public PollResponse<Void> waitUntil(LongRunningOperationStatus longRunningOperationStatus) {
            return this.voidResponse(this.syncPoller.waitUntil(longRunningOperationStatus));
        }

        @Override
        public PollResponse<Void> waitUntil(Duration duration, LongRunningOperationStatus longRunningOperationStatus) {
            return this.voidResponse(this.syncPoller.waitUntil(duration, longRunningOperationStatus));
        }

        @Override
        public T getFinalResult() {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.finalResult == null) {
                PollResponse<PollResult<InnerT>> response;
                InnerT innerFinalResult = this.syncPoller.getFinalResult();
                if (innerFinalResult == null && ((response = this.syncPoller.poll()).getStatus() == LongRunningOperationStatus.FAILED || response.getStatus() == LongRunningOperationStatus.USER_CANCELLED)) {
                    this.exception = this.errorOperation.apply(response);
                    throw this.exception;
                }
                this.finalResult = this.wrapOperation.apply(innerFinalResult);
            }
            return this.finalResult;
        }

        @Override
        public void cancelOperation() {
            this.syncPoller.cancelOperation();
        }

        private PollResponse<Void> voidResponse(PollResponse<PollResult<InnerT>> pollResponse) {
            return new PollResponse<Object>(pollResponse.getStatus(), null, pollResponse.getRetryAfter());
        }
    }

    private static class ResourceWithProvisioningState
    implements JsonSerializable<ResourceWithProvisioningState> {
        private Properties properties;

        private ResourceWithProvisioningState() {
        }

        private String getProvisioningState() {
            if (this.properties != null) {
                return this.properties.provisioningState;
            }
            return null;
        }

        @Override
        public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
            return jsonWriter.writeStartObject().writeJsonField("properties", this.properties).writeEndObject();
        }

        public static ResourceWithProvisioningState fromJson(JsonReader jsonReader) throws IOException {
            return jsonReader.readObject(reader -> {
                ResourceWithProvisioningState resourceWithProvisioningState = new ResourceWithProvisioningState();
                while (reader.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = reader.getFieldName();
                    reader.nextToken();
                    if ("properties".equals(fieldName)) {
                        resourceWithProvisioningState.properties = reader.readObject(Properties::fromJson);
                        continue;
                    }
                    reader.skipChildren();
                }
                return resourceWithProvisioningState;
            });
        }

        private static class Properties
        implements JsonSerializable<Properties> {
            private String provisioningState;

            private Properties() {
            }

            @Override
            public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
                return jsonWriter.writeStartObject().writeStringField("provisioningState", this.provisioningState).writeEndObject();
            }

            public static Properties fromJson(JsonReader jsonReader) throws IOException {
                return jsonReader.readObject(reader -> {
                    Properties result = new Properties();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("provisioningState".equals(fieldName)) {
                            result.provisioningState = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    return result;
                });
            }
        }
    }

    private static class ProvisioningState {
        static final String IN_PROGRESS = "InProgress";
        static final String SUCCEEDED = "Succeeded";
        static final String FAILED = "Failed";
        static final String CANCELED = "Canceled";

        private ProvisioningState() {
        }
    }

    private static class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        @Override
        public Flux<ByteBuffer> getBody() {
            return Flux.just(ByteBuffer.wrap(this.responseBody));
        }

        @Override
        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just(this.responseBody);
        }

        @Override
        public Mono<String> getBodyAsString() {
            return Mono.just(new String(this.responseBody, StandardCharsets.UTF_8));
        }

        @Override
        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just(new String(this.responseBody, charset));
        }
    }
}

