/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class CreateUpdateTask<ResourceT extends Indexable>
implements TaskItem {
    private ResourceCreatorUpdater<ResourceT> resourceCreatorUpdater;
    private ResourceT resource;

    public CreateUpdateTask(ResourceCreatorUpdater<ResourceT> resourceCreatorUpdater) {
        this.resourceCreatorUpdater = resourceCreatorUpdater;
    }

    public ResourceT result() {
        return this.resource;
    }

    @Override
    public void beforeGroupInvoke() {
        this.resourceCreatorUpdater.beforeGroupCreateOrUpdate();
    }

    @Override
    public Mono<Indexable> invokeAsync(TaskGroup.InvocationContext context) {
        if (this.resourceCreatorUpdater.isInCreateMode()) {
            return this.resourceCreatorUpdater.createResourceAsync().subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler()).doOnNext(resourceT -> {
                this.resource = resourceT;
            }).map(resourceT -> resourceT);
        }
        return this.resourceCreatorUpdater.updateResourceAsync().subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler()).doOnNext(resourceT -> {
            this.resource = resourceT;
        }).map(resourceT -> resourceT);
    }

    @Override
    public Mono<Void> invokeAfterPostRunAsync(boolean isGroupFaulted) {
        return this.resourceCreatorUpdater.afterPostRunAsync(isGroupFaulted);
    }

    @Override
    public boolean isHot() {
        return this.resourceCreatorUpdater.isHot();
    }

    public static interface ResourceCreatorUpdater<T extends Indexable> {
        public boolean isInCreateMode();

        public void beforeGroupCreateOrUpdate();

        public Mono<T> createResourceAsync();

        public Mono<T> updateResourceAsync();

        public boolean isHot();

        public Mono<Void> afterPostRunAsync(boolean var1);
    }
}

