/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.ProxyResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.SearchServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.DataPlaneAuthOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.EncryptionWithCmk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.HostingMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.NetworkRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchSemanticSearch;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchServiceStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.Sku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SearchServiceUpdate
extends ProxyResource {
    private SearchServiceProperties innerProperties;
    private Sku sku;
    private String location;
    private Map<String, String> tags;
    private Identity identity;
    private String id;
    private String name;
    private String type;

    private SearchServiceProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public SearchServiceUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String location() {
        return this.location;
    }

    public SearchServiceUpdate withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SearchServiceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public SearchServiceUpdate withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    public Integer replicaCount() {
        return this.innerProperties() == null ? null : this.innerProperties().replicaCount();
    }

    public SearchServiceUpdate withReplicaCount(Integer replicaCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withReplicaCount(replicaCount);
        return this;
    }

    public Integer partitionCount() {
        return this.innerProperties() == null ? null : this.innerProperties().partitionCount();
    }

    public SearchServiceUpdate withPartitionCount(Integer partitionCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withPartitionCount(partitionCount);
        return this;
    }

    public HostingMode hostingMode() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingMode();
    }

    public SearchServiceUpdate withHostingMode(HostingMode hostingMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withHostingMode(hostingMode);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public SearchServiceUpdate withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public SearchServiceStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String statusDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().statusDetails();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public SearchServiceUpdate withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public EncryptionWithCmk encryptionWithCmk() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionWithCmk();
    }

    public SearchServiceUpdate withEncryptionWithCmk(EncryptionWithCmk encryptionWithCmk) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withEncryptionWithCmk(encryptionWithCmk);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public SearchServiceUpdate withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public DataPlaneAuthOptions authOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().authOptions();
    }

    public SearchServiceUpdate withAuthOptions(DataPlaneAuthOptions authOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withAuthOptions(authOptions);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public SearchSemanticSearch semanticSearch() {
        return this.innerProperties() == null ? null : this.innerProperties().semanticSearch();
    }

    public SearchServiceUpdate withSemanticSearch(SearchSemanticSearch semanticSearch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withSemanticSearch(semanticSearch);
        return this;
    }

    public List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedPrivateLinkResources();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SearchServiceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchServiceUpdate deserializedSearchServiceUpdate = new SearchServiceUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSearchServiceUpdate.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSearchServiceUpdate.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSearchServiceUpdate.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSearchServiceUpdate.innerProperties = SearchServiceProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedSearchServiceUpdate.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSearchServiceUpdate.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSearchServiceUpdate.tags = tags;
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSearchServiceUpdate.identity = Identity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchServiceUpdate;
        });
    }
}

