/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DatabaseLicenseType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DatabaseReadScale;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DatabaseStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SampleName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SecondaryType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;

public final class DatabaseUpdateProperties
implements JsonSerializable<DatabaseUpdateProperties> {
    private CreateMode createMode;
    private String collation;
    private Long maxSizeBytes;
    private SampleName sampleName;
    private String elasticPoolId;
    private String sourceDatabaseId;
    private DatabaseStatus status;
    private UUID databaseId;
    private OffsetDateTime creationDate;
    private String currentServiceObjectiveName;
    private String requestedServiceObjectiveName;
    private String defaultSecondaryLocation;
    private String failoverGroupId;
    private OffsetDateTime restorePointInTime;
    private OffsetDateTime sourceDatabaseDeletionDate;
    private String recoveryServicesRecoveryPointId;
    private String longTermRetentionBackupResourceId;
    private String recoverableDatabaseId;
    private String restorableDroppedDatabaseId;
    private CatalogCollationType catalogCollation;
    private Boolean zoneRedundant;
    private DatabaseLicenseType licenseType;
    private Long maxLogSizeBytes;
    private OffsetDateTime earliestRestoreDate;
    private DatabaseReadScale readScale;
    private Integer highAvailabilityReplicaCount;
    private SecondaryType secondaryType;
    private Sku currentSku;
    private Integer autoPauseDelay;
    private BackupStorageRedundancy currentBackupStorageRedundancy;
    private BackupStorageRedundancy requestedBackupStorageRedundancy;
    private Double minCapacity;
    private OffsetDateTime pausedDate;
    private OffsetDateTime resumedDate;
    private String maintenanceConfigurationId;
    private Boolean isLedgerOn;
    private Boolean isInfraEncryptionEnabled;
    private UUID federatedClientId;

    public CreateMode createMode() {
        return this.createMode;
    }

    public DatabaseUpdateProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String collation() {
        return this.collation;
    }

    public DatabaseUpdateProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public DatabaseUpdateProperties withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public SampleName sampleName() {
        return this.sampleName;
    }

    public DatabaseUpdateProperties withSampleName(SampleName sampleName) {
        this.sampleName = sampleName;
        return this;
    }

    public String elasticPoolId() {
        return this.elasticPoolId;
    }

    public DatabaseUpdateProperties withElasticPoolId(String elasticPoolId) {
        this.elasticPoolId = elasticPoolId;
        return this;
    }

    public String sourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public DatabaseUpdateProperties withSourceDatabaseId(String sourceDatabaseId) {
        this.sourceDatabaseId = sourceDatabaseId;
        return this;
    }

    public DatabaseStatus status() {
        return this.status;
    }

    public UUID databaseId() {
        return this.databaseId;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String currentServiceObjectiveName() {
        return this.currentServiceObjectiveName;
    }

    public String requestedServiceObjectiveName() {
        return this.requestedServiceObjectiveName;
    }

    public String defaultSecondaryLocation() {
        return this.defaultSecondaryLocation;
    }

    public String failoverGroupId() {
        return this.failoverGroupId;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public DatabaseUpdateProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public OffsetDateTime sourceDatabaseDeletionDate() {
        return this.sourceDatabaseDeletionDate;
    }

    public DatabaseUpdateProperties withSourceDatabaseDeletionDate(OffsetDateTime sourceDatabaseDeletionDate) {
        this.sourceDatabaseDeletionDate = sourceDatabaseDeletionDate;
        return this;
    }

    public String recoveryServicesRecoveryPointId() {
        return this.recoveryServicesRecoveryPointId;
    }

    public DatabaseUpdateProperties withRecoveryServicesRecoveryPointId(String recoveryServicesRecoveryPointId) {
        this.recoveryServicesRecoveryPointId = recoveryServicesRecoveryPointId;
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.longTermRetentionBackupResourceId;
    }

    public DatabaseUpdateProperties withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        this.longTermRetentionBackupResourceId = longTermRetentionBackupResourceId;
        return this;
    }

    public String recoverableDatabaseId() {
        return this.recoverableDatabaseId;
    }

    public DatabaseUpdateProperties withRecoverableDatabaseId(String recoverableDatabaseId) {
        this.recoverableDatabaseId = recoverableDatabaseId;
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.restorableDroppedDatabaseId;
    }

    public DatabaseUpdateProperties withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        this.restorableDroppedDatabaseId = restorableDroppedDatabaseId;
        return this;
    }

    public CatalogCollationType catalogCollation() {
        return this.catalogCollation;
    }

    public DatabaseUpdateProperties withCatalogCollation(CatalogCollationType catalogCollation) {
        this.catalogCollation = catalogCollation;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public DatabaseUpdateProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public DatabaseLicenseType licenseType() {
        return this.licenseType;
    }

    public DatabaseUpdateProperties withLicenseType(DatabaseLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public Long maxLogSizeBytes() {
        return this.maxLogSizeBytes;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public DatabaseReadScale readScale() {
        return this.readScale;
    }

    public DatabaseUpdateProperties withReadScale(DatabaseReadScale readScale) {
        this.readScale = readScale;
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.highAvailabilityReplicaCount;
    }

    public DatabaseUpdateProperties withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        this.highAvailabilityReplicaCount = highAvailabilityReplicaCount;
        return this;
    }

    public SecondaryType secondaryType() {
        return this.secondaryType;
    }

    public DatabaseUpdateProperties withSecondaryType(SecondaryType secondaryType) {
        this.secondaryType = secondaryType;
        return this;
    }

    public Sku currentSku() {
        return this.currentSku;
    }

    public Integer autoPauseDelay() {
        return this.autoPauseDelay;
    }

    public DatabaseUpdateProperties withAutoPauseDelay(Integer autoPauseDelay) {
        this.autoPauseDelay = autoPauseDelay;
        return this;
    }

    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.currentBackupStorageRedundancy;
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    public DatabaseUpdateProperties withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    public Double minCapacity() {
        return this.minCapacity;
    }

    public DatabaseUpdateProperties withMinCapacity(Double minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public OffsetDateTime pausedDate() {
        return this.pausedDate;
    }

    public OffsetDateTime resumedDate() {
        return this.resumedDate;
    }

    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    public DatabaseUpdateProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    public Boolean isLedgerOn() {
        return this.isLedgerOn;
    }

    public DatabaseUpdateProperties withIsLedgerOn(Boolean isLedgerOn) {
        this.isLedgerOn = isLedgerOn;
        return this;
    }

    public Boolean isInfraEncryptionEnabled() {
        return this.isInfraEncryptionEnabled;
    }

    public UUID federatedClientId() {
        return this.federatedClientId;
    }

    public DatabaseUpdateProperties withFederatedClientId(UUID federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    public void validate() {
        if (this.currentSku() != null) {
            this.currentSku().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeStringField("collation", this.collation);
        jsonWriter.writeNumberField("maxSizeBytes", this.maxSizeBytes);
        jsonWriter.writeStringField("sampleName", this.sampleName == null ? null : this.sampleName.toString());
        jsonWriter.writeStringField("elasticPoolId", this.elasticPoolId);
        jsonWriter.writeStringField("sourceDatabaseId", this.sourceDatabaseId);
        jsonWriter.writeStringField("restorePointInTime", this.restorePointInTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restorePointInTime));
        jsonWriter.writeStringField("sourceDatabaseDeletionDate", this.sourceDatabaseDeletionDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sourceDatabaseDeletionDate));
        jsonWriter.writeStringField("recoveryServicesRecoveryPointId", this.recoveryServicesRecoveryPointId);
        jsonWriter.writeStringField("longTermRetentionBackupResourceId", this.longTermRetentionBackupResourceId);
        jsonWriter.writeStringField("recoverableDatabaseId", this.recoverableDatabaseId);
        jsonWriter.writeStringField("restorableDroppedDatabaseId", this.restorableDroppedDatabaseId);
        jsonWriter.writeStringField("catalogCollation", this.catalogCollation == null ? null : this.catalogCollation.toString());
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeStringField("readScale", this.readScale == null ? null : this.readScale.toString());
        jsonWriter.writeNumberField("highAvailabilityReplicaCount", this.highAvailabilityReplicaCount);
        jsonWriter.writeStringField("secondaryType", this.secondaryType == null ? null : this.secondaryType.toString());
        jsonWriter.writeNumberField("autoPauseDelay", this.autoPauseDelay);
        jsonWriter.writeStringField("requestedBackupStorageRedundancy", this.requestedBackupStorageRedundancy == null ? null : this.requestedBackupStorageRedundancy.toString());
        jsonWriter.writeNumberField("minCapacity", this.minCapacity);
        jsonWriter.writeStringField("maintenanceConfigurationId", this.maintenanceConfigurationId);
        jsonWriter.writeBooleanField("isLedgerOn", this.isLedgerOn);
        jsonWriter.writeStringField("federatedClientId", Objects.toString(this.federatedClientId, null));
        return jsonWriter.writeEndObject();
    }

    public static DatabaseUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseUpdateProperties deserializedDatabaseUpdateProperties = new DatabaseUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createMode".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("collation".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.collation = reader.getString();
                    continue;
                }
                if ("maxSizeBytes".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.maxSizeBytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sampleName".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.sampleName = SampleName.fromString(reader.getString());
                    continue;
                }
                if ("elasticPoolId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.elasticPoolId = reader.getString();
                    continue;
                }
                if ("sourceDatabaseId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.sourceDatabaseId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.status = DatabaseStatus.fromString(reader.getString());
                    continue;
                }
                if ("databaseId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.databaseId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.creationDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("currentServiceObjectiveName".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.currentServiceObjectiveName = reader.getString();
                    continue;
                }
                if ("requestedServiceObjectiveName".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.requestedServiceObjectiveName = reader.getString();
                    continue;
                }
                if ("defaultSecondaryLocation".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.defaultSecondaryLocation = reader.getString();
                    continue;
                }
                if ("failoverGroupId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.failoverGroupId = reader.getString();
                    continue;
                }
                if ("restorePointInTime".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.restorePointInTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("sourceDatabaseDeletionDate".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.sourceDatabaseDeletionDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("recoveryServicesRecoveryPointId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.recoveryServicesRecoveryPointId = reader.getString();
                    continue;
                }
                if ("longTermRetentionBackupResourceId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.longTermRetentionBackupResourceId = reader.getString();
                    continue;
                }
                if ("recoverableDatabaseId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.recoverableDatabaseId = reader.getString();
                    continue;
                }
                if ("restorableDroppedDatabaseId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.restorableDroppedDatabaseId = reader.getString();
                    continue;
                }
                if ("catalogCollation".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.catalogCollation = CatalogCollationType.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.licenseType = DatabaseLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("maxLogSizeBytes".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.maxLogSizeBytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("earliestRestoreDate".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.earliestRestoreDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("readScale".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.readScale = DatabaseReadScale.fromString(reader.getString());
                    continue;
                }
                if ("highAvailabilityReplicaCount".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.highAvailabilityReplicaCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("secondaryType".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.secondaryType = SecondaryType.fromString(reader.getString());
                    continue;
                }
                if ("currentSku".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.currentSku = Sku.fromJson(reader);
                    continue;
                }
                if ("autoPauseDelay".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.autoPauseDelay = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentBackupStorageRedundancy".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.currentBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("requestedBackupStorageRedundancy".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.requestedBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("minCapacity".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.minCapacity = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pausedDate".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.pausedDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("resumedDate".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.resumedDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("maintenanceConfigurationId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.maintenanceConfigurationId = reader.getString();
                    continue;
                }
                if ("isLedgerOn".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.isLedgerOn = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isInfraEncryptionEnabled".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.isInfraEncryptionEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("federatedClientId".equals(fieldName)) {
                    deserializedDatabaseUpdateProperties.federatedClientId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseUpdateProperties;
        });
    }
}

