/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.JobStepAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.JobStepExecutionOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.JobStepOutput;
import java.io.IOException;

public final class JobStepProperties
implements JsonSerializable<JobStepProperties> {
    private Integer stepId;
    private String targetGroup;
    private String credential;
    private JobStepAction action;
    private JobStepOutput output;
    private JobStepExecutionOptions executionOptions;
    private static final ClientLogger LOGGER = new ClientLogger(JobStepProperties.class);

    public Integer stepId() {
        return this.stepId;
    }

    public JobStepProperties withStepId(Integer stepId) {
        this.stepId = stepId;
        return this;
    }

    public String targetGroup() {
        return this.targetGroup;
    }

    public JobStepProperties withTargetGroup(String targetGroup) {
        this.targetGroup = targetGroup;
        return this;
    }

    public String credential() {
        return this.credential;
    }

    public JobStepProperties withCredential(String credential) {
        this.credential = credential;
        return this;
    }

    public JobStepAction action() {
        return this.action;
    }

    public JobStepProperties withAction(JobStepAction action) {
        this.action = action;
        return this;
    }

    public JobStepOutput output() {
        return this.output;
    }

    public JobStepProperties withOutput(JobStepOutput output) {
        this.output = output;
        return this;
    }

    public JobStepExecutionOptions executionOptions() {
        return this.executionOptions;
    }

    public JobStepProperties withExecutionOptions(JobStepExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
        return this;
    }

    public void validate() {
        if (this.targetGroup() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property targetGroup in model JobStepProperties"));
        }
        if (this.credential() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property credential in model JobStepProperties"));
        }
        if (this.action() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property action in model JobStepProperties"));
        }
        this.action().validate();
        if (this.output() != null) {
            this.output().validate();
        }
        if (this.executionOptions() != null) {
            this.executionOptions().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetGroup", this.targetGroup);
        jsonWriter.writeStringField("credential", this.credential);
        jsonWriter.writeJsonField("action", this.action);
        jsonWriter.writeNumberField("stepId", this.stepId);
        jsonWriter.writeJsonField("output", this.output);
        jsonWriter.writeJsonField("executionOptions", this.executionOptions);
        return jsonWriter.writeEndObject();
    }

    public static JobStepProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobStepProperties deserializedJobStepProperties = new JobStepProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetGroup".equals(fieldName)) {
                    deserializedJobStepProperties.targetGroup = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedJobStepProperties.credential = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedJobStepProperties.action = JobStepAction.fromJson(reader);
                    continue;
                }
                if ("stepId".equals(fieldName)) {
                    deserializedJobStepProperties.stepId = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    deserializedJobStepProperties.output = JobStepOutput.fromJson(reader);
                    continue;
                }
                if ("executionOptions".equals(fieldName)) {
                    deserializedJobStepProperties.executionOptions = JobStepExecutionOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobStepProperties;
        });
    }
}

