/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedInstanceExternalAdministrator;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedInstanceLicenseType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedInstancePecProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedInstancePropertiesProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedInstanceProxyOverride;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedServerCreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServicePrincipal;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ManagedInstanceProperties
implements JsonSerializable<ManagedInstanceProperties> {
    private ManagedInstancePropertiesProvisioningState provisioningState;
    private ManagedServerCreateMode managedInstanceCreateMode;
    private String fullyQualifiedDomainName;
    private String administratorLogin;
    private String administratorLoginPassword;
    private String subnetId;
    private String state;
    private ManagedInstanceLicenseType licenseType;
    private Integer vCores;
    private Integer storageSizeInGB;
    private String collation;
    private String dnsZone;
    private String dnsZonePartner;
    private Boolean publicDataEndpointEnabled;
    private String sourceManagedInstanceId;
    private OffsetDateTime restorePointInTime;
    private ManagedInstanceProxyOverride proxyOverride;
    private String timezoneId;
    private String instancePoolId;
    private String maintenanceConfigurationId;
    private List<ManagedInstancePecProperty> privateEndpointConnections;
    private String minimalTlsVersion;
    private BackupStorageRedundancy currentBackupStorageRedundancy;
    private BackupStorageRedundancy requestedBackupStorageRedundancy;
    private Boolean zoneRedundant;
    private String primaryUserAssignedIdentityId;
    private String keyId;
    private ManagedInstanceExternalAdministrator administrators;
    private ServicePrincipal servicePrincipal;

    public ManagedInstancePropertiesProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ManagedServerCreateMode managedInstanceCreateMode() {
        return this.managedInstanceCreateMode;
    }

    public ManagedInstanceProperties withManagedInstanceCreateMode(ManagedServerCreateMode managedInstanceCreateMode) {
        this.managedInstanceCreateMode = managedInstanceCreateMode;
        return this;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ManagedInstanceProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ManagedInstanceProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public ManagedInstanceProperties withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String state() {
        return this.state;
    }

    public ManagedInstanceLicenseType licenseType() {
        return this.licenseType;
    }

    public ManagedInstanceProperties withLicenseType(ManagedInstanceLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public Integer vCores() {
        return this.vCores;
    }

    public ManagedInstanceProperties withVCores(Integer vCores) {
        this.vCores = vCores;
        return this;
    }

    public Integer storageSizeInGB() {
        return this.storageSizeInGB;
    }

    public ManagedInstanceProperties withStorageSizeInGB(Integer storageSizeInGB) {
        this.storageSizeInGB = storageSizeInGB;
        return this;
    }

    public String collation() {
        return this.collation;
    }

    public ManagedInstanceProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public String dnsZone() {
        return this.dnsZone;
    }

    public String dnsZonePartner() {
        return this.dnsZonePartner;
    }

    public ManagedInstanceProperties withDnsZonePartner(String dnsZonePartner) {
        this.dnsZonePartner = dnsZonePartner;
        return this;
    }

    public Boolean publicDataEndpointEnabled() {
        return this.publicDataEndpointEnabled;
    }

    public ManagedInstanceProperties withPublicDataEndpointEnabled(Boolean publicDataEndpointEnabled) {
        this.publicDataEndpointEnabled = publicDataEndpointEnabled;
        return this;
    }

    public String sourceManagedInstanceId() {
        return this.sourceManagedInstanceId;
    }

    public ManagedInstanceProperties withSourceManagedInstanceId(String sourceManagedInstanceId) {
        this.sourceManagedInstanceId = sourceManagedInstanceId;
        return this;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public ManagedInstanceProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public ManagedInstanceProxyOverride proxyOverride() {
        return this.proxyOverride;
    }

    public ManagedInstanceProperties withProxyOverride(ManagedInstanceProxyOverride proxyOverride) {
        this.proxyOverride = proxyOverride;
        return this;
    }

    public String timezoneId() {
        return this.timezoneId;
    }

    public ManagedInstanceProperties withTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
        return this;
    }

    public String instancePoolId() {
        return this.instancePoolId;
    }

    public ManagedInstanceProperties withInstancePoolId(String instancePoolId) {
        this.instancePoolId = instancePoolId;
        return this;
    }

    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    public ManagedInstanceProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    public List<ManagedInstancePecProperty> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ManagedInstanceProperties withMinimalTlsVersion(String minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.currentBackupStorageRedundancy;
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    public ManagedInstanceProperties withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ManagedInstanceProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    public ManagedInstanceProperties withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    public String keyId() {
        return this.keyId;
    }

    public ManagedInstanceProperties withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public ManagedInstanceExternalAdministrator administrators() {
        return this.administrators;
    }

    public ManagedInstanceProperties withAdministrators(ManagedInstanceExternalAdministrator administrators) {
        this.administrators = administrators;
        return this;
    }

    public ServicePrincipal servicePrincipal() {
        return this.servicePrincipal;
    }

    public ManagedInstanceProperties withServicePrincipal(ServicePrincipal servicePrincipal) {
        this.servicePrincipal = servicePrincipal;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.administrators() != null) {
            this.administrators().validate();
        }
        if (this.servicePrincipal() != null) {
            this.servicePrincipal().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("managedInstanceCreateMode", this.managedInstanceCreateMode == null ? null : this.managedInstanceCreateMode.toString());
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeNumberField("vCores", this.vCores);
        jsonWriter.writeNumberField("storageSizeInGB", this.storageSizeInGB);
        jsonWriter.writeStringField("collation", this.collation);
        jsonWriter.writeStringField("dnsZonePartner", this.dnsZonePartner);
        jsonWriter.writeBooleanField("publicDataEndpointEnabled", this.publicDataEndpointEnabled);
        jsonWriter.writeStringField("sourceManagedInstanceId", this.sourceManagedInstanceId);
        jsonWriter.writeStringField("restorePointInTime", this.restorePointInTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restorePointInTime));
        jsonWriter.writeStringField("proxyOverride", this.proxyOverride == null ? null : this.proxyOverride.toString());
        jsonWriter.writeStringField("timezoneId", this.timezoneId);
        jsonWriter.writeStringField("instancePoolId", this.instancePoolId);
        jsonWriter.writeStringField("maintenanceConfigurationId", this.maintenanceConfigurationId);
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion);
        jsonWriter.writeStringField("requestedBackupStorageRedundancy", this.requestedBackupStorageRedundancy == null ? null : this.requestedBackupStorageRedundancy.toString());
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeStringField("primaryUserAssignedIdentityId", this.primaryUserAssignedIdentityId);
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeJsonField("administrators", this.administrators);
        jsonWriter.writeJsonField("servicePrincipal", this.servicePrincipal);
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceProperties deserializedManagedInstanceProperties = new ManagedInstanceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedInstanceProperties.provisioningState = ManagedInstancePropertiesProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("managedInstanceCreateMode".equals(fieldName)) {
                    deserializedManagedInstanceProperties.managedInstanceCreateMode = ManagedServerCreateMode.fromString(reader.getString());
                    continue;
                }
                if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedManagedInstanceProperties.fullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("administratorLogin".equals(fieldName)) {
                    deserializedManagedInstanceProperties.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedManagedInstanceProperties.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.subnetId = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedManagedInstanceProperties.state = reader.getString();
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedManagedInstanceProperties.licenseType = ManagedInstanceLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("vCores".equals(fieldName)) {
                    deserializedManagedInstanceProperties.vCores = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageSizeInGB".equals(fieldName)) {
                    deserializedManagedInstanceProperties.storageSizeInGB = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("collation".equals(fieldName)) {
                    deserializedManagedInstanceProperties.collation = reader.getString();
                    continue;
                }
                if ("dnsZone".equals(fieldName)) {
                    deserializedManagedInstanceProperties.dnsZone = reader.getString();
                    continue;
                }
                if ("dnsZonePartner".equals(fieldName)) {
                    deserializedManagedInstanceProperties.dnsZonePartner = reader.getString();
                    continue;
                }
                if ("publicDataEndpointEnabled".equals(fieldName)) {
                    deserializedManagedInstanceProperties.publicDataEndpointEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sourceManagedInstanceId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.sourceManagedInstanceId = reader.getString();
                    continue;
                }
                if ("restorePointInTime".equals(fieldName)) {
                    deserializedManagedInstanceProperties.restorePointInTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("proxyOverride".equals(fieldName)) {
                    deserializedManagedInstanceProperties.proxyOverride = ManagedInstanceProxyOverride.fromString(reader.getString());
                    continue;
                }
                if ("timezoneId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.timezoneId = reader.getString();
                    continue;
                }
                if ("instancePoolId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.instancePoolId = reader.getString();
                    continue;
                }
                if ("maintenanceConfigurationId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.maintenanceConfigurationId = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List<ManagedInstancePecProperty> privateEndpointConnections = reader.readArray(reader1 -> ManagedInstancePecProperty.fromJson(reader1));
                    deserializedManagedInstanceProperties.privateEndpointConnections = privateEndpointConnections;
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedManagedInstanceProperties.minimalTlsVersion = reader.getString();
                    continue;
                }
                if ("currentBackupStorageRedundancy".equals(fieldName)) {
                    deserializedManagedInstanceProperties.currentBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("requestedBackupStorageRedundancy".equals(fieldName)) {
                    deserializedManagedInstanceProperties.requestedBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedManagedInstanceProperties.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("primaryUserAssignedIdentityId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.primaryUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("keyId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.keyId = reader.getString();
                    continue;
                }
                if ("administrators".equals(fieldName)) {
                    deserializedManagedInstanceProperties.administrators = ManagedInstanceExternalAdministrator.fromJson(reader);
                    continue;
                }
                if ("servicePrincipal".equals(fieldName)) {
                    deserializedManagedInstanceProperties.servicePrincipal = ServicePrincipal.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceProperties;
        });
    }
}

