/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.BlobServicesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.BlobServicePropertiesInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.IdParsingUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.CorsRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.CorsRules;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.DeleteRetentionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LastAccessTimeTrackingPolicy;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.List;

class BlobServicePropertiesImpl
extends CreatableUpdatableImpl<BlobServiceProperties, BlobServicePropertiesInner, BlobServicePropertiesImpl>
implements BlobServiceProperties,
BlobServiceProperties.Definition,
BlobServiceProperties.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;

    BlobServicePropertiesImpl(String name, StorageManager manager) {
        super(name, new BlobServicePropertiesInner());
        this.manager = manager;
        this.accountName = name;
    }

    BlobServicePropertiesImpl(BlobServicePropertiesInner inner, StorageManager manager) {
        super(inner.name(), inner);
        this.manager = manager;
        this.accountName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
    }

    @Override
    public StorageManager manager() {
        return this.manager;
    }

    @Override
    public Mono<BlobServiceProperties> createResourceAsync() {
        BlobServicesClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobServices();
        return client.setServicePropertiesAsync(this.resourceGroupName, this.accountName, (BlobServicePropertiesInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<BlobServiceProperties> updateResourceAsync() {
        BlobServicesClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobServices();
        return client.setServicePropertiesAsync(this.resourceGroupName, this.accountName, (BlobServicePropertiesInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<BlobServicePropertiesInner> getInnerAsync() {
        BlobServicesClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobServices();
        return client.getServicePropertiesAsync(this.resourceGroupName, this.accountName);
    }

    @Override
    public boolean isInCreateMode() {
        return ((BlobServicePropertiesInner)this.innerModel()).id() == null;
    }

    @Override
    public CorsRules cors() {
        return ((BlobServicePropertiesInner)this.innerModel()).cors();
    }

    @Override
    public String defaultServiceVersion() {
        return ((BlobServicePropertiesInner)this.innerModel()).defaultServiceVersion();
    }

    @Override
    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return ((BlobServicePropertiesInner)this.innerModel()).deleteRetentionPolicy();
    }

    @Override
    public DeleteRetentionPolicy containerDeleteRetentionPolicy() {
        return ((BlobServicePropertiesInner)this.innerModel()).containerDeleteRetentionPolicy();
    }

    @Override
    public String id() {
        return ((BlobServicePropertiesInner)this.innerModel()).id();
    }

    @Override
    public String name() {
        return ((BlobServicePropertiesInner)this.innerModel()).name();
    }

    @Override
    public String type() {
        return ((BlobServicePropertiesInner)this.innerModel()).type();
    }

    @Override
    public Boolean isBlobVersioningEnabled() {
        return ((BlobServicePropertiesInner)this.innerModel()).isVersioningEnabled();
    }

    @Override
    public boolean isLastAccessTimeTrackingPolicyEnabled() {
        return ((BlobServicePropertiesInner)this.innerModel()).lastAccessTimeTrackingPolicy() != null && ResourceManagerUtils.toPrimitiveBoolean(((BlobServicePropertiesInner)this.innerModel()).lastAccessTimeTrackingPolicy().enable());
    }

    @Override
    public LastAccessTimeTrackingPolicy lastAccessTimeTrackingPolicy() {
        return ((BlobServicePropertiesInner)this.innerModel()).lastAccessTimeTrackingPolicy();
    }

    @Override
    public BlobServicePropertiesImpl withExistingStorageAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withCORSRules(List<CorsRule> corsRules) {
        ((BlobServicePropertiesInner)this.innerModel()).withCors(new CorsRules().withCorsRules(corsRules));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withCORSRule(CorsRule corsRule) {
        CorsRules corsRules = ((BlobServicePropertiesInner)this.innerModel()).cors();
        if (corsRules == null) {
            ArrayList<CorsRule> firstCorsRule = new ArrayList<CorsRule>();
            firstCorsRule.add(corsRule);
            ((BlobServicePropertiesInner)this.innerModel()).withCors(new CorsRules().withCorsRules(firstCorsRule));
        } else {
            List<CorsRule> currentCorsRules = corsRules.corsRules();
            currentCorsRules.add(corsRule);
            ((BlobServicePropertiesInner)this.innerModel()).withCors(corsRules.withCorsRules(currentCorsRules));
        }
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDefaultServiceVersion(String defaultServiceVersion) {
        ((BlobServicePropertiesInner)this.innerModel()).withDefaultServiceVersion(defaultServiceVersion);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        ((BlobServicePropertiesInner)this.innerModel()).withDeleteRetentionPolicy(deleteRetentionPolicy);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicyEnabled(int numDaysEnabled) {
        ((BlobServicePropertiesInner)this.innerModel()).withDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(true).withDays(numDaysEnabled));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicyDisabled() {
        ((BlobServicePropertiesInner)this.innerModel()).withDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(false));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withBlobVersioningEnabled() {
        ((BlobServicePropertiesInner)this.innerModel()).withIsVersioningEnabled(true);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withBlobVersioningDisabled() {
        ((BlobServicePropertiesInner)this.innerModel()).withIsVersioningEnabled(false);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withContainerDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        ((BlobServicePropertiesInner)this.innerModel()).withContainerDeleteRetentionPolicy(deleteRetentionPolicy);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withContainerDeleteRetentionPolicyEnabled(int numDaysEnabled) {
        ((BlobServicePropertiesInner)this.innerModel()).withContainerDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(true).withDays(numDaysEnabled));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withContainerDeleteRetentionPolicyDisabled() {
        ((BlobServicePropertiesInner)this.innerModel()).withContainerDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(false));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withLastAccessTimeTrackingPolicyEnabled() {
        if (((BlobServicePropertiesInner)this.innerModel()).lastAccessTimeTrackingPolicy() == null) {
            ((BlobServicePropertiesInner)this.innerModel()).withLastAccessTimeTrackingPolicy(new LastAccessTimeTrackingPolicy());
        }
        ((BlobServicePropertiesInner)this.innerModel()).lastAccessTimeTrackingPolicy().withEnable(true);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withLastAccessTimeTrackingPolicy(LastAccessTimeTrackingPolicy policy) {
        ((BlobServicePropertiesInner)this.innerModel()).withLastAccessTimeTrackingPolicy(policy);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withLastAccessTimeTrackingPolicyDisabled() {
        if (((BlobServicePropertiesInner)this.innerModel()).lastAccessTimeTrackingPolicy() != null) {
            ((BlobServicePropertiesInner)this.innerModel()).lastAccessTimeTrackingPolicy().withEnable(false);
        }
        return this;
    }
}

