/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Patch;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.FileSharesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.FileShareInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.FileShareItemInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.LeaseShareResponseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.DeletedShare;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.FileShareItems;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.FileSharesLeaseResponse;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LeaseShareRequest;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class FileSharesClientImpl
implements FileSharesClient {
    private final FileSharesService service;
    private final StorageManagementClientImpl client;

    FileSharesClientImpl(StorageManagementClientImpl client) {
        this.service = RestProxy.create(FileSharesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FileShareItemInner>> listSinglePageAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), maxpagesize, filter, expand, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, FileShareItemInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileShareItems)res.getValue()).value(), ((FileShareItems)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FileShareItemInner>> listSinglePageAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), maxpagesize, filter, expand, "application/json", context).map(res -> new PagedResponseBase<Object, FileShareItemInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileShareItems)res.getValue()).value(), ((FileShareItems)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileShareItemInner> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, String expand) {
        return new PagedFlux<FileShareItemInner>(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileShareItemInner> listAsync(String resourceGroupName, String accountName) {
        String maxpagesize = null;
        String filter = null;
        String expand = null;
        return new PagedFlux<FileShareItemInner>(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FileShareItemInner> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, String expand, Context context) {
        return new PagedFlux<FileShareItemInner>(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FileShareItemInner> list(String resourceGroupName, String accountName) {
        String maxpagesize = null;
        String filter = null;
        String expand = null;
        return new PagedIterable<FileShareItemInner>(this.listAsync(resourceGroupName, accountName, maxpagesize, filter, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FileShareItemInner> list(String resourceGroupName, String accountName, String maxpagesize, String filter, String expand, Context context) {
        return new PagedIterable<FileShareItemInner>(this.listAsync(resourceGroupName, accountName, maxpagesize, filter, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FileShareInner>> createWithResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        }
        fileShare.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, accountName, shareName, expand, this.client.getApiVersion(), this.client.getSubscriptionId(), fileShare, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FileShareInner>> createWithResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        }
        fileShare.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, accountName, shareName, expand, this.client.getApiVersion(), this.client.getSubscriptionId(), fileShare, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileShareInner> createAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        String expand = null;
        return this.createWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, expand).flatMap(res -> Mono.justOrEmpty((FileShareInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileShareInner> createWithResponse(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, String expand, Context context) {
        return this.createWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileShareInner create(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        String expand = null;
        return this.createWithResponse(resourceGroupName, accountName, shareName, fileShare, expand, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FileShareInner>> updateWithResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        }
        fileShare.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), fileShare, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FileShareInner>> updateWithResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        }
        fileShare.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), fileShare, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileShareInner> updateAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return this.updateWithResponseAsync(resourceGroupName, accountName, shareName, fileShare).flatMap(res -> Mono.justOrEmpty((FileShareInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileShareInner> updateWithResponse(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, Context context) {
        return this.updateWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileShareInner update(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return this.updateWithResponse(resourceGroupName, accountName, shareName, fileShare, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FileShareInner>> getWithResponseAsync(String resourceGroupName, String accountName, String shareName, String expand, String xMsSnapshot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), expand, xMsSnapshot, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FileShareInner>> getWithResponseAsync(String resourceGroupName, String accountName, String shareName, String expand, String xMsSnapshot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), expand, xMsSnapshot, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileShareInner> getAsync(String resourceGroupName, String accountName, String shareName) {
        String expand = null;
        String xMsSnapshot = null;
        return this.getWithResponseAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot).flatMap(res -> Mono.justOrEmpty((FileShareInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileShareInner> getWithResponse(String resourceGroupName, String accountName, String shareName, String expand, String xMsSnapshot, Context context) {
        return this.getWithResponseAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileShareInner get(String resourceGroupName, String accountName, String shareName) {
        String expand = null;
        String xMsSnapshot = null;
        return this.getWithResponse(resourceGroupName, accountName, shareName, expand, xMsSnapshot, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, String shareName, String xMsSnapshot, String include) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), xMsSnapshot, include, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, String shareName, String xMsSnapshot, String include, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), xMsSnapshot, include, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, String shareName) {
        String xMsSnapshot = null;
        String include = null;
        return this.deleteWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, include).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String accountName, String shareName, String xMsSnapshot, String include, Context context) {
        return this.deleteWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, include, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String shareName) {
        String xMsSnapshot = null;
        String include = null;
        this.deleteWithResponse(resourceGroupName, accountName, shareName, xMsSnapshot, include, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> restoreWithResponseAsync(String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deletedShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter deletedShare is required and cannot be null."));
        }
        deletedShare.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), deletedShare, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> restoreWithResponseAsync(String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deletedShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter deletedShare is required and cannot be null."));
        }
        deletedShare.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), deletedShare, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare) {
        return this.restoreWithResponseAsync(resourceGroupName, accountName, shareName, deletedShare).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> restoreWithResponse(String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare, Context context) {
        return this.restoreWithResponseAsync(resourceGroupName, accountName, shareName, deletedShare, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restore(String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare) {
        this.restoreWithResponse(resourceGroupName, accountName, shareName, deletedShare, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSharesLeaseResponse> leaseWithResponseAsync(String resourceGroupName, String accountName, String shareName, String xMsSnapshot, LeaseShareRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.lease(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), xMsSnapshot, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FileSharesLeaseResponse> leaseWithResponseAsync(String resourceGroupName, String accountName, String shareName, String xMsSnapshot, LeaseShareRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.lease(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), xMsSnapshot, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LeaseShareResponseInner> leaseAsync(String resourceGroupName, String accountName, String shareName) {
        String xMsSnapshot = null;
        LeaseShareRequest parameters = null;
        return this.leaseWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, parameters).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileSharesLeaseResponse leaseWithResponse(String resourceGroupName, String accountName, String shareName, String xMsSnapshot, LeaseShareRequest parameters, Context context) {
        return this.leaseWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LeaseShareResponseInner lease(String resourceGroupName, String accountName, String shareName) {
        String xMsSnapshot = null;
        LeaseShareRequest parameters = null;
        return this.leaseWithResponse(resourceGroupName, accountName, shareName, xMsSnapshot, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FileShareItemInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, FileShareItemInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileShareItems)res.getValue()).value(), ((FileShareItems)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FileShareItemInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, FileShareItemInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileShareItems)res.getValue()).value(), ((FileShareItems)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementCli")
    public static interface FileSharesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareItems>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="$maxpagesize") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$expand") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="$expand") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") FileShareInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") FileShareInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="$expand") String var7, @HeaderParam(value="x-ms-snapshot") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="x-ms-snapshot") String var7, @QueryParam(value="$include") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> restore(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") DeletedShare var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}/lease")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<FileSharesLeaseResponse> lease(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="x-ms-snapshot") String var7, @BodyParam(value="application/json") LeaseShareRequest var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareItems>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

