/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.Attributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.DeletionRecoveryLevel;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class SecretAttributes
extends Attributes {
    private Integer recoverableDays;
    private DeletionRecoveryLevel recoveryLevel;
    private Long updated;
    private Long created;

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public DeletionRecoveryLevel getRecoveryLevel() {
        return this.recoveryLevel;
    }

    @Override
    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    @Override
    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    @Override
    public SecretAttributes setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public SecretAttributes setNotBefore(OffsetDateTime notBefore) {
        super.setNotBefore(notBefore);
        return this;
    }

    @Override
    public SecretAttributes setExpires(OffsetDateTime expires) {
        super.setExpires(expires);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.isEnabled());
        if (this.getNotBefore() != null) {
            jsonWriter.writeNumberField("nbf", this.getNotBefore().toEpochSecond());
        }
        if (this.getExpires() != null) {
            jsonWriter.writeNumberField("exp", this.getExpires().toEpochSecond());
        }
        return jsonWriter.writeEndObject();
    }

    public static SecretAttributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretAttributes deserializedSecretAttributes = new SecretAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedSecretAttributes.setEnabled(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    Long notBeforeHolder = reader.getNullable(JsonReader::getLong);
                    if (notBeforeHolder == null) continue;
                    deserializedSecretAttributes.setNotBefore(OffsetDateTime.ofInstant(Instant.ofEpochSecond(notBeforeHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    Long expiresHolder = reader.getNullable(JsonReader::getLong);
                    if (expiresHolder == null) continue;
                    deserializedSecretAttributes.setExpires(OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedSecretAttributes.created = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedSecretAttributes.updated = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("recoverableDays".equals(fieldName)) {
                    deserializedSecretAttributes.recoverableDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("recoveryLevel".equals(fieldName)) {
                    deserializedSecretAttributes.recoveryLevel = DeletionRecoveryLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretAttributes;
        });
    }
}

