/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobItemPropertiesInternal;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobName;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobTags;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobItemInternal
implements XmlSerializable<BlobItemInternal> {
    private BlobName name;
    private boolean deleted;
    private String snapshot;
    private String versionId;
    private Boolean isCurrentVersion;
    private BlobItemPropertiesInternal properties;
    private Map<String, String> metadata;
    private BlobTags blobTags;
    private Map<String, String> objectReplicationMetadata;
    private Boolean hasVersionsOnly;
    private Boolean isPrefix;

    public BlobName getName() {
        return this.name;
    }

    public BlobItemInternal setName(BlobName name) {
        this.name = name;
        return this;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public BlobItemInternal setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public BlobItemInternal setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public BlobItemInternal setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    public BlobItemInternal setIsCurrentVersion(Boolean isCurrentVersion) {
        this.isCurrentVersion = isCurrentVersion;
        return this;
    }

    public BlobItemPropertiesInternal getProperties() {
        return this.properties;
    }

    public BlobItemInternal setProperties(BlobItemPropertiesInternal properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlobItemInternal setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BlobTags getBlobTags() {
        return this.blobTags;
    }

    public BlobItemInternal setBlobTags(BlobTags blobTags) {
        this.blobTags = blobTags;
        return this;
    }

    public Map<String, String> getObjectReplicationMetadata() {
        return this.objectReplicationMetadata;
    }

    public BlobItemInternal setObjectReplicationMetadata(Map<String, String> objectReplicationMetadata) {
        this.objectReplicationMetadata = objectReplicationMetadata;
        return this;
    }

    public Boolean isHasVersionsOnly() {
        return this.hasVersionsOnly;
    }

    public BlobItemInternal setHasVersionsOnly(Boolean hasVersionsOnly) {
        this.hasVersionsOnly = hasVersionsOnly;
        return this;
    }

    public Boolean isPrefix() {
        return this.isPrefix;
    }

    public BlobItemInternal setIsPrefix(Boolean isPrefix) {
        this.isPrefix = isPrefix;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Blob" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.name, "Name");
        xmlWriter.writeBooleanElement("Deleted", this.deleted);
        xmlWriter.writeStringElement("Snapshot", this.snapshot);
        xmlWriter.writeStringElement("VersionId", this.versionId);
        xmlWriter.writeBooleanElement("IsCurrentVersion", this.isCurrentVersion);
        xmlWriter.writeXml(this.properties, "Properties");
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeXml(this.blobTags, "Tags");
        if (this.objectReplicationMetadata != null) {
            xmlWriter.writeStartElement("OrMetadata");
            for (Map.Entry<String, String> entry : this.objectReplicationMetadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeBooleanElement("HasVersionsOnly", this.hasVersionsOnly);
        xmlWriter.writeBooleanElement("IsPrefix", this.isPrefix);
        return xmlWriter.writeEndElement();
    }

    public static BlobItemInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobItemInternal.fromXml(xmlReader, null);
    }

    public static BlobItemInternal fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Blob" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobItemInternal deserializedBlobItemInternal = new BlobItemInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.name = BlobName.fromXml(reader, "Name");
                    continue;
                }
                if ("Deleted".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.deleted = reader.getBooleanElement();
                    continue;
                }
                if ("Snapshot".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.snapshot = reader.getStringElement();
                    continue;
                }
                if ("VersionId".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.versionId = reader.getStringElement();
                    continue;
                }
                if ("IsCurrentVersion".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.isCurrentVersion = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.properties = BlobItemPropertiesInternal.fromXml(reader, "Properties");
                    continue;
                }
                if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedBlobItemInternal.metadata == null) {
                            deserializedBlobItemInternal.metadata = new LinkedHashMap<String, String>();
                        }
                        deserializedBlobItemInternal.metadata.put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                    continue;
                }
                if ("Tags".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.blobTags = BlobTags.fromXml(reader, "Tags");
                    continue;
                }
                if ("OrMetadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedBlobItemInternal.objectReplicationMetadata == null) {
                            deserializedBlobItemInternal.objectReplicationMetadata = new LinkedHashMap<String, String>();
                        }
                        deserializedBlobItemInternal.objectReplicationMetadata.put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                    continue;
                }
                if ("HasVersionsOnly".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.hasVersionsOnly = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("IsPrefix".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.isPrefix = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobItemInternal;
        });
    }
}

