/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.AzureSasCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.ConfigurationTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.ConnectionStringTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.EndpointTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.HttpTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.TokenCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureNamedKeyCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.StorageSharedKeyCredential;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.SasImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.credentials.CredentialValidator;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.policy.RequestRetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.sas.CommonSasQueryParameters;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.util.BuilderHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareAudience;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareTokenIntent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ShareClient.class, ShareAsyncClient.class})
public class ShareClientBuilder
implements TokenCredentialTrait<ShareClientBuilder>,
HttpTrait<ShareClientBuilder>,
ConnectionStringTrait<ShareClientBuilder>,
AzureNamedKeyCredentialTrait<ShareClientBuilder>,
AzureSasCredentialTrait<ShareClientBuilder>,
ConfigurationTrait<ShareClientBuilder>,
EndpointTrait<ShareClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(ShareClientBuilder.class);
    private String endpoint;
    private String accountName;
    private String shareName;
    private String snapshot;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private AzureSasCredential azureSasCredential;
    private TokenCredential tokenCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private ShareServiceVersion version;
    private ShareTokenIntent shareTokenIntent;
    private boolean allowSourceTrailingDot;
    private boolean allowTrailingDot;
    private ShareAudience audience;

    public ShareClientBuilder() {
        this.logOptions = ShareClientBuilder.getDefaultHttpLogOptions();
    }

    public ShareAsyncClient buildAsyncClient() {
        AzureFileStorageImpl azureFileStorage = this.buildFileStorageImplClient();
        AzureSasCredential azureSasCredentialFromSasToken = this.sasToken != null ? new AzureSasCredential(this.sasToken) : null;
        return new ShareAsyncClient(azureFileStorage, this.shareName, this.snapshot, this.accountName, this.version, azureSasCredentialFromSasToken != null ? azureSasCredentialFromSasToken : this.azureSasCredential);
    }

    public ShareClient buildClient() {
        AzureFileStorageImpl azureFileStorage = this.buildFileStorageImplClient();
        AzureSasCredential azureSasCredentialFromSasToken = this.sasToken != null ? new AzureSasCredential(this.sasToken) : null;
        return new ShareClient(azureFileStorage, this.shareName, this.snapshot, this.accountName, this.version, azureSasCredentialFromSasToken != null ? azureSasCredentialFromSasToken : this.azureSasCredential);
    }

    @Override
    public ShareClientBuilder endpoint(String endpoint) {
        try {
            String sasToken;
            URL fullUrl = new URL(endpoint);
            this.endpoint = fullUrl.getProtocol() + "://" + fullUrl.getHost();
            this.accountName = BuilderHelper.getAccountName(fullUrl);
            String[] pathSegments = fullUrl.getPath().split("/");
            int length = pathSegments.length;
            if (length > 3) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Cannot accept a URL to a file or directory to construct a file share client"));
            }
            this.shareName = length >= 2 ? pathSegments[1] : this.shareName;
            Map<String, String[]> queryParamsMap = SasImplUtils.parseQueryString(fullUrl.getQuery());
            String[] snapshotArray = queryParamsMap.remove("sharesnapshot");
            if (snapshotArray != null) {
                this.snapshot = snapshotArray[0];
            }
            if (!CoreUtils.isNullOrEmpty(sasToken = new CommonSasQueryParameters(SasImplUtils.parseQueryString(fullUrl.getQuery()), false).encode())) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Azure Storage File Service endpoint url is malformed.", ex));
        }
        return this;
    }

    public ShareClientBuilder shareName(String shareName) {
        this.shareName = Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        return this;
    }

    public ShareClientBuilder snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public ShareClientBuilder credential(StorageSharedKeyCredential credential) {
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    @Override
    public ShareClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential(credential));
    }

    @Override
    public ShareClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public ShareClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    @Override
    public ShareClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    @Override
    public ShareClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create(connectionString, LOGGER);
        StorageEndpoint endpoint = storageConnectionString.getFileEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("connectionString missing required settings to derive file service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    @Override
    public ShareClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    @Override
    public ShareClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    @Override
    public ShareClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    @Override
    public ShareClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ShareClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    @Override
    public ShareClientBuilder retryOptions(RetryOptions retryOptions) {
        this.coreRetryOptions = retryOptions;
        return this;
    }

    @Override
    public ShareClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    @Override
    public ShareClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public ShareClientBuilder serviceVersion(ShareServiceVersion version) {
        this.version = version;
        return this;
    }

    public ShareClientBuilder allowSourceTrailingDot(boolean allowSourceTrailingDot) {
        this.allowSourceTrailingDot = allowSourceTrailingDot;
        return this;
    }

    public ShareClientBuilder allowTrailingDot(boolean allowTrailingDot) {
        this.allowTrailingDot = allowTrailingDot;
        return this;
    }

    public ShareClientBuilder shareTokenIntent(ShareTokenIntent shareTokenIntent) {
        this.shareTokenIntent = shareTokenIntent;
        return this;
    }

    public ShareClientBuilder audience(ShareAudience audience) {
        this.audience = audience;
        return this;
    }

    AzureFileStorageImpl buildFileStorageImplClient() {
        Objects.requireNonNull(this.shareName, "'shareName' cannot be null.");
        CredentialValidator.validateSingleCredentialIsPresent(this.storageSharedKeyCredential, null, this.azureSasCredential, this.sasToken, LOGGER);
        ShareServiceVersion serviceVersion = this.version != null ? this.version : ShareServiceVersion.getLatest();
        this.serviceVersion(serviceVersion);
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.sasToken, this.endpoint, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.audience, LOGGER);
        return new AzureFileStorageImpl(pipeline, serviceVersion.getVersion(), this.shareTokenIntent, this.endpoint, this.allowTrailingDot, this.allowSourceTrailingDot);
    }
}

