/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.AvroObject;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.AvroParserState;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.AvroSimpleSchema;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.AvroType;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.file.AvroBlockSchema;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.file.AvroHeaderSchema;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AvroParser {
    private static final ClientLogger LOGGER = new ClientLogger(AvroParser.class);
    private AvroParserState state = new AvroParserState();
    private byte[] syncMarker;
    private AvroType objectType;
    private List<AvroObject> objects = new ArrayList<AvroObject>();
    private final boolean partialRead;

    AvroParser(boolean partialRead) {
        this.partialRead = partialRead;
        AvroHeaderSchema headerSchema = new AvroHeaderSchema(this.state, this::onFilteredHeader);
        headerSchema.pushToStack();
    }

    Mono<Void> prepareParserToReadBody(long sourceOffset, long thresholdIndex) {
        if (!this.partialRead) {
            return Mono.error(new IllegalStateException("This method should only be called when parsing header and body separately."));
        }
        if (this.objectType == null || this.syncMarker == null) {
            return Mono.error(new IllegalStateException("Expected to read entire header before preparing parser to read body."));
        }
        this.state = new AvroParserState(sourceOffset);
        this.objects = new ArrayList<AvroObject>();
        this.onBlock(thresholdIndex);
        return Mono.empty();
    }

    private void onFilteredHeader(Object header) {
        AvroSchema.checkType("header", header, Map.class);
        Map h = (Map)header;
        Object type = h.get("meta");
        AvroSchema.checkType("type", type, AvroType.class);
        this.objectType = (AvroType)type;
        Object sync = h.get("sync");
        AvroSchema.checkType("sync", sync, byte[].class);
        this.syncMarker = (byte[])sync;
        if (!this.partialRead) {
            this.onBlock(0L);
        }
    }

    private void onBlock(Object beginObjectIndex) {
        AvroSchema.checkType("beginObjectIndex", beginObjectIndex, Long.class);
        AvroBlockSchema blockSchema = new AvroBlockSchema(this.objectType, (Long)beginObjectIndex, o -> {
            AvroSchema.checkType("object", o, AvroObject.class);
            this.objects.add((AvroObject)o);
        }, this.syncMarker, this.state, this::onBlock);
        blockSchema.pushToStack();
    }

    public Flux<AvroObject> parse(ByteBuffer buffer) {
        Flux<AvroObject> result;
        ByteBuffer allocatedBuffer = ByteBuffer.allocate(buffer.remaining());
        allocatedBuffer.put(buffer);
        allocatedBuffer.position(0);
        this.state.write(allocatedBuffer);
        if (this.partialRead && this.state.isStackEmpty()) {
            return Flux.empty();
        }
        AvroSchema schema = this.state.peekFromStack();
        while (schema instanceof AvroCompositeSchema || schema instanceof AvroSimpleSchema && ((AvroSimpleSchema)schema).canProgress()) {
            if (schema instanceof AvroSimpleSchema) {
                ((AvroSimpleSchema)schema).progress();
            }
            if (schema.isDone()) {
                this.state.popOffStack();
                schema.publishResult();
            } else if (schema instanceof AvroCompositeSchema) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Expected composite type to be done."));
            }
            if (this.partialRead && this.state.isStackEmpty()) break;
            schema = this.state.peekFromStack();
        }
        if (this.objects.isEmpty()) {
            result = Flux.empty();
        } else {
            result = Flux.fromIterable(this.objects);
            this.objects = new ArrayList<AvroObject>();
        }
        return result;
    }
}

