/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j;

import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.MsalClientException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.token.AccessToken;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.dataiku.dss.shadelibazure.net.minidev.json.JSONObject;
import lombok.Generated;

class TokenResponse
extends OIDCTokenResponse {
    private String scope;
    private String clientInfo;
    private long expiresIn;
    private long extExpiresIn;
    private String foci;
    private long refreshIn;

    TokenResponse(AccessToken accessToken, RefreshToken refreshToken, String idToken, String scope, String clientInfo, long expiresIn, long extExpiresIn, String foci, long refreshIn) {
        super(new OIDCTokens(idToken, accessToken, refreshToken));
        this.scope = scope;
        this.clientInfo = clientInfo;
        this.expiresIn = expiresIn;
        this.extExpiresIn = extExpiresIn;
        this.refreshIn = refreshIn;
        this.foci = foci;
    }

    static TokenResponse parseHttpResponse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return TokenResponse.parseJsonObject(jsonObject);
    }

    static Long getLongValue(JSONObject jsonObject, String key) throws ParseException {
        Object value = jsonObject.get(key);
        if (value instanceof Long) {
            return JSONObjectUtils.getLong(jsonObject, key);
        }
        return Long.parseLong(JSONObjectUtils.getString(jsonObject, key));
    }

    static TokenResponse parseJsonObject(JSONObject jsonObject) throws ParseException {
        String idTokenValue = "";
        if (jsonObject.containsKey("id_token")) {
            idTokenValue = JSONObjectUtils.getString(jsonObject, "id_token");
        }
        String scopeValue = null;
        if (jsonObject.containsKey("scope")) {
            scopeValue = JSONObjectUtils.getString(jsonObject, "scope");
        }
        String clientInfo = null;
        if (jsonObject.containsKey("client_info")) {
            clientInfo = JSONObjectUtils.getString(jsonObject, "client_info");
        }
        long expiresIn = 0L;
        if (jsonObject.containsKey("expires_in")) {
            expiresIn = TokenResponse.getLongValue(jsonObject, "expires_in");
        }
        long ext_expires_in = 0L;
        if (jsonObject.containsKey("ext_expires_in")) {
            ext_expires_in = TokenResponse.getLongValue(jsonObject, "ext_expires_in");
        }
        String foci = null;
        if (jsonObject.containsKey("foci")) {
            foci = JSONObjectUtils.getString(jsonObject, "foci");
        }
        long refreshIn = 0L;
        if (jsonObject.containsKey("refresh_in")) {
            refreshIn = TokenResponse.getLongValue(jsonObject, "refresh_in");
        }
        try {
            AccessToken accessToken = AccessToken.parse(jsonObject);
            RefreshToken refreshToken = RefreshToken.parse(jsonObject);
            return new TokenResponse(accessToken, refreshToken, idTokenValue, scopeValue, clientInfo, expiresIn, ext_expires_in, foci, refreshIn);
        }
        catch (ParseException e) {
            throw new MsalClientException("Invalid or missing token, could not parse. If using B2C, information on a potential B2C issue and workaround can be found here: https://aka.ms/msal4j-b2c-known-issues", "invalid_json");
        }
        catch (Exception e) {
            throw new MsalClientException(e);
        }
    }

    @Generated
    String getScope() {
        return this.scope;
    }

    @Generated
    String getClientInfo() {
        return this.clientInfo;
    }

    @Generated
    long getExpiresIn() {
        return this.expiresIn;
    }

    @Generated
    long getExtExpiresIn() {
        return this.extExpiresIn;
    }

    @Generated
    String getFoci() {
        return this.foci;
    }

    @Generated
    long getRefreshIn() {
        return this.refreshIn;
    }
}

