/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j;

import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ClaimsRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.HttpMethod;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ParameterValidationUtils;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.PopParameters;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class UserNamePasswordParameters
implements IAcquireTokenParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private String username;
    @NonNull
    private char[] password;
    private ClaimsRequest claims;
    private Map<String, String> extraHttpHeaders;
    private Map<String, String> extraQueryParameters;
    private String tenant;
    private PopParameters proofOfPossession;

    public char[] password() {
        return (char[])this.password.clone();
    }

    private static UserNamePasswordParametersBuilder builder() {
        return new UserNamePasswordParametersBuilder();
    }

    public static UserNamePasswordParametersBuilder builder(Set<String> scopes, String username, char[] password) {
        ParameterValidationUtils.validateNotNull("scopes", scopes);
        ParameterValidationUtils.validateNotBlank("username", username);
        ParameterValidationUtils.validateNotEmpty("password", password);
        return UserNamePasswordParameters.builder().scopes(scopes).username(username).password(password);
    }

    @Override
    @NonNull
    @Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    @Generated
    public String username() {
        return this.username;
    }

    @Override
    @Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    @Override
    @Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    @Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    @Override
    @Generated
    public String tenant() {
        return this.tenant;
    }

    @Generated
    public PopParameters proofOfPossession() {
        return this.proofOfPossession;
    }

    @Generated
    private UserNamePasswordParameters(@NonNull Set<String> scopes, @NonNull String username, @NonNull char[] password, ClaimsRequest claims, Map<String, String> extraHttpHeaders, Map<String, String> extraQueryParameters, String tenant, PopParameters proofOfPossession) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.scopes = scopes;
        this.username = username;
        this.password = password;
        this.claims = claims;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
        this.proofOfPossession = proofOfPossession;
    }

    public static class UserNamePasswordParametersBuilder {
        @Generated
        private Set<String> scopes;
        @Generated
        private String username;
        @Generated
        private char[] password;
        @Generated
        private ClaimsRequest claims;
        @Generated
        private Map<String, String> extraHttpHeaders;
        @Generated
        private Map<String, String> extraQueryParameters;
        @Generated
        private String tenant;
        @Generated
        private PopParameters proofOfPossession;

        public UserNamePasswordParametersBuilder password(char[] password) {
            this.password = (char[])password.clone();
            return this;
        }

        public UserNamePasswordParametersBuilder proofOfPossession(HttpMethod httpMethod, URI uri, String nonce) {
            this.proofOfPossession = new PopParameters(httpMethod, uri, nonce);
            return this;
        }

        @Generated
        UserNamePasswordParametersBuilder() {
        }

        @Generated
        public UserNamePasswordParametersBuilder scopes(@NonNull Set<String> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        @Generated
        public UserNamePasswordParametersBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        @Generated
        public UserNamePasswordParametersBuilder claims(ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @Generated
        public UserNamePasswordParametersBuilder extraHttpHeaders(Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        @Generated
        public UserNamePasswordParametersBuilder extraQueryParameters(Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        @Generated
        public UserNamePasswordParametersBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        @Generated
        public UserNamePasswordParameters build() {
            return new UserNamePasswordParameters(this.scopes, this.username, this.password, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant, this.proofOfPossession);
        }

        @Generated
        public String toString() {
            return "UserNamePasswordParameters.UserNamePasswordParametersBuilder(scopes=" + this.scopes + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ", proofOfPossession=" + this.proofOfPossession + ")";
        }
    }
}

