/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth.verifier;

import com.dataiku.dss.shadelibazure.com.nimbusds.jose.proc.SecurityContext;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.proc.BadJWTException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetailsVerifier;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Audience;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.util.Set;

@Immutable
class JWTAuthenticationClaimsSetVerifier
extends JWTAssertionDetailsVerifier {
    private static final BadJWTException ISS_SUB_MISMATCH_EXCEPTION = new BadJWTException("Issuer and subject JWT claims don't match");

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> expectedAudience) {
        this(expectedAudience, -1L);
    }

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> expectedAudience, long expMaxAhead) {
        super(expectedAudience, expMaxAhead);
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, SecurityContext securityContext) throws BadJWTException {
        super.verify(claimsSet, securityContext);
        if (!claimsSet.getIssuer().equals(claimsSet.getSubject())) {
            throw ISS_SUB_MISMATCH_EXCEPTION;
        }
    }
}

