/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.dpop;

import com.dataiku.dss.shadelibazure.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.jwk.JWK;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.util.Base64URL;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.cnf.AbstractConfirmation;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import com.dataiku.dss.shadelibazure.net.minidev.json.JSONObject;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;

@Immutable
public final class JWKThumbprintConfirmation
extends AbstractConfirmation {
    private final Base64URL jkt;

    public JWKThumbprintConfirmation(Base64URL jkt) {
        this.jkt = Objects.requireNonNull(jkt);
    }

    public Base64URL getValue() {
        return this.jkt;
    }

    @Override
    public Map.Entry<String, JSONObject> toJWTClaim() {
        JSONObject cnf = new JSONObject();
        cnf.put("jkt", this.jkt.toString());
        return new AbstractMap.SimpleImmutableEntry<String, JSONObject>("cnf", cnf);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWKThumbprintConfirmation)) {
            return false;
        }
        JWKThumbprintConfirmation that = (JWKThumbprintConfirmation)o;
        return this.jkt.equals(that.jkt);
    }

    public int hashCode() {
        return Objects.hash(this.jkt);
    }

    public static JWKThumbprintConfirmation parse(JWTClaimsSet jwtClaimsSet) {
        JSONObject cnf = JWKThumbprintConfirmation.parseConfirmationJSONObject(jwtClaimsSet);
        if (cnf == null) {
            return null;
        }
        return JWKThumbprintConfirmation.parseFromConfirmationJSONObject(cnf);
    }

    public static JWKThumbprintConfirmation parse(JSONObject jsonObject) {
        if (!jsonObject.containsKey("cnf")) {
            return null;
        }
        try {
            return JWKThumbprintConfirmation.parseFromConfirmationJSONObject(JSONObjectUtils.getJSONObject(jsonObject, "cnf"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static JWKThumbprintConfirmation parseFromConfirmationJSONObject(JSONObject cnf) {
        if (cnf == null) {
            return null;
        }
        try {
            String jktString = JSONObjectUtils.getString(cnf, "jkt");
            return new JWKThumbprintConfirmation(new Base64URL(jktString));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static JWKThumbprintConfirmation of(JWK jwk) throws JOSEException {
        return new JWKThumbprintConfirmation(jwk.computeThumbprint());
    }
}

