/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk;

import com.dataiku.dss.shadelibazure.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.SerializeException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.token.AccessToken;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.URLUtils;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

@Immutable
public class UserInfoRequest
extends ProtectedResourceRequest {
    private final HTTPRequest.Method httpMethod;

    public UserInfoRequest(URI endpoint, AccessToken accessToken) {
        this(endpoint, HTTPRequest.Method.GET, accessToken);
    }

    public UserInfoRequest(URI endpoint, HTTPRequest.Method httpMethod, AccessToken accessToken) {
        super(endpoint, Objects.requireNonNull(accessToken));
        this.httpMethod = Objects.requireNonNull(httpMethod);
    }

    public HTTPRequest.Method getMethod() {
        return this.httpMethod;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(this.httpMethod, this.getEndpointURI());
        switch (this.httpMethod) {
            case GET: {
                httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
                break;
            }
            case POST: {
                httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
                HashMap<String, List<String>> params = new HashMap<String, List<String>>();
                params.put("access_token", Collections.singletonList(this.getAccessToken().getValue()));
                httpRequest.setBody(URLUtils.serializeParameters(params));
                break;
            }
            default: {
                throw new SerializeException("Unexpected HTTP method: " + (Object)((Object)this.httpMethod));
            }
        }
        return httpRequest;
    }

    public static UserInfoRequest parse(HTTPRequest httpRequest) throws ParseException {
        return new UserInfoRequest(httpRequest.getURI(), httpRequest.getMethod(), AccessToken.parse(httpRequest));
    }
}

